/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.RFCServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class WebSocketServletRFCTest {
    private static final String REQUEST_HASH_KEY = "dGhlIHNhbXBsZSBub25jZQ==";
    private static Generator generator = new UnitGenerator();
    private static SimpleServletServer server;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new RFCServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testBinaryAggregate() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            byte[] buf1 = new byte[128];
            byte[] buf2 = new byte[128];
            byte[] buf3 = new byte[128];
            Arrays.fill(buf1, (byte)-86);
            Arrays.fill(buf2, (byte)-69);
            Arrays.fill(buf3, (byte)-52);
            WebSocketFrame bin = new BinaryFrame().setPayload(buf1).setFin(false);
            clientConn.write(bin);
            bin = new ContinuationFrame().setPayload(buf2).setFin(false);
            clientConn.write(bin);
            bin = new ContinuationFrame().setPayload(buf3).setFin(true);
            clientConn.write(bin);
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            Frame binmsg = (Frame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            int expectedSize = buf1.length + buf2.length + buf3.length;
            MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)binmsg.getPayloadLength(), (Matcher)Matchers.is((Object)expectedSize));
            int aaCount = 0;
            int bbCount = 0;
            int ccCount = 0;
            ByteBuffer echod = binmsg.getPayload();
            block10: while (echod.remaining() >= 1) {
                byte b = echod.get();
                switch (b) {
                    case -86: {
                        ++aaCount;
                        continue block10;
                    }
                    case -69: {
                        ++bbCount;
                        continue block10;
                    }
                    case -52: {
                        ++ccCount;
                        continue block10;
                    }
                }
                Assertions.fail((String)String.format("Encountered invalid byte 0x%02X", (byte)(0xFF & b)));
            }
            MatcherAssert.assertThat((String)"Echoed data count for 0xAA", (Object)aaCount, (Matcher)Matchers.is((Object)buf1.length));
            MatcherAssert.assertThat((String)"Echoed data count for 0xBB", (Object)bbCount, (Matcher)Matchers.is((Object)buf2.length));
            MatcherAssert.assertThat((String)"Echoed data count for 0xCC", (Object)ccCount, (Matcher)Matchers.is((Object)buf3.length));
        }
    }

    @Test
    public void testDetectBadUTF8() {
        byte[] buf = new byte[]{-62, -61};
        Utf8StringBuilder utf = new Utf8StringBuilder();
        Assertions.assertThrows(Utf8Appendable.NotUtf8Exception.class, () -> utf.append(buf, 0, buf.length));
    }

    @Test
    public void testEcho() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            String msg = "this is an echo ... cho ... ho ... o";
            clientConn.write((WebSocketFrame)new TextFrame().setPayload(msg));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame.status code", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg));
        }
    }

    @Test
    public void testInternalError() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);
             StacklessLogging ignore = new StacklessLogging(new Class[]{EventDriver.class});){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("CRASH"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            Frame cf = (Frame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            CloseInfo close = new CloseInfo(cf);
            MatcherAssert.assertThat((String)"Close Frame.status code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1011));
        }
    }

    @Test
    public void testLowercaseUpgrade() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header("upgrade", "websocket");
        request.header("connection", "upgrade");
        request.header("sec-websocket-key", REQUEST_HASH_KEY);
        request.header("sec-websocket-origin", server.getServerUri().toASCIIString());
        request.header("sec-websocket-protocol", "echo");
        request.header("sec-websocket-version", "13");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            String msg = "this is an echo ... cho ... ho ... o";
            clientConn.write((WebSocketFrame)new TextFrame().setPayload(msg));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame.status code", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg));
        }
    }

    @Test
    public void testTextNotUTF8() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "other");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);
             StacklessLogging ignore = new StacklessLogging(new Class[]{Parser.class});){
            byte[] buf = new byte[]{-62, -61};
            WebSocketFrame txt = new TextFrame().setPayload(ByteBuffer.wrap(buf));
            txt.setMask(Hex.asByteArray((String)"11223344"));
            ByteBuffer bbHeader = generator.generateHeaderBytes((Frame)txt);
            clientConn.writeRaw(bbHeader);
            clientConn.writeRaw(txt.getPayload());
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame frame = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"frames[0].opcode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
            CloseInfo close = new CloseInfo((Frame)frame);
            MatcherAssert.assertThat((String)"Close Status Code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1007));
        }
    }

    @Test
    public void testUppercaseUpgrade() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header("UPGRADE", "WEBSOCKET");
        request.header("CONNECTION", "UPGRADE");
        request.header("SEC-WEBSOCKET-KEY", REQUEST_HASH_KEY.toUpperCase(Locale.US));
        request.header("SEC-WEBSOCKET-ORIGIN", server.getServerUri().toASCIIString());
        request.header("SEC-WEBSOCKET-PROTOCOL", "ECHO");
        request.header("SEC-WEBSOCKET-VERSION", "13");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            String msg = "this is an echo ... cho ... ho ... o";
            clientConn.write((WebSocketFrame)new TextFrame().setPayload(msg));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame.status code", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg));
        }
    }
}

