/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.InfoContextAltAttributeListener;
import org.eclipse.jetty.websocket.server.InfoContextAttributeListener;
import org.eclipse.jetty.websocket.server.InfoContextListener;
import org.eclipse.jetty.websocket.server.InfoServlet;
import org.eclipse.jetty.websocket.server.InfoSocket;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.server.WSServer;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class WebSocketUpgradeFilterTest {
    private static BlockheadClient client;
    private static AtomicInteger uniqTestDirId;
    private Server server;
    private URI serverUri;

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    private static File getNewTestDir() {
        return MavenTestingUtils.getTargetTestingDir((String)("WSUF-webxml-" + uniqTestDirId.getAndIncrement()));
    }

    public static Stream<Arguments> scenarios() {
        final WebSocketCreator infoCreator = (req, resp) -> new InfoSocket();
        ArrayList<Arguments> cases = new ArrayList<Arguments>();
        cases.add(Arguments.of((Object[])new Object[]{"wsuf.configureContext/Direct configure", () -> {
            Server server1 = new Server();
            ServerConnector connector = new ServerConnector(server1);
            connector.setPort(0);
            server1.addConnector((Connector)connector);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            server1.setHandler((Handler)context);
            WebSocketUpgradeFilter wsuf = WebSocketUpgradeFilter.configureContext((ServletContextHandler)context);
            wsuf.getFactory().getPolicy().setMaxTextMessageSize(0xA00000);
            wsuf.addMapping("/info/*", infoCreator);
            server1.start();
            return server1;
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf.configureContext/Attribute based configure", () -> {
            Server server12 = new Server();
            ServerConnector connector = new ServerConnector(server12);
            connector.setPort(0);
            server12.addConnector((Connector)connector);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            server12.setHandler((Handler)context);
            WebSocketUpgradeFilter.configureContext((ServletContextHandler)context);
            NativeWebSocketConfiguration configuration = (NativeWebSocketConfiguration)context.getServletContext().getAttribute(NativeWebSocketConfiguration.class.getName());
            MatcherAssert.assertThat((String)"NativeWebSocketConfiguration", (Object)configuration, (Matcher)Matchers.notNullValue());
            configuration.getFactory().getPolicy().setMaxTextMessageSize(0xA00000);
            configuration.addMapping("/info/*", infoCreator);
            server12.start();
            return server12;
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf/addFilter/Attribute based configure", () -> {
            Server server13 = new Server();
            ServerConnector connector = new ServerConnector(server13);
            connector.setPort(0);
            server13.addConnector((Connector)connector);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            server13.setHandler((Handler)context);
            context.addFilter(WebSocketUpgradeFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            NativeWebSocketConfiguration configuration = new NativeWebSocketConfiguration((ServletContext)context.getServletContext());
            configuration.getFactory().getPolicy().setMaxTextMessageSize(0xA00000);
            configuration.addMapping("/info/*", infoCreator);
            context.setAttribute(NativeWebSocketConfiguration.class.getName(), (Object)configuration);
            server13.start();
            return server13;
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf/addFilter/WSUF Constructor configure", new ServerProvider(){

            @Override
            public Server newServer() throws Exception {
                Server server = new Server();
                ServerConnector connector = new ServerConnector(server);
                connector.setPort(0);
                server.addConnector((Connector)connector);
                ServletContextHandler context = new ServletContextHandler();
                context.setContextPath("/");
                server.setHandler((Handler)context);
                NativeWebSocketConfiguration configuration = new NativeWebSocketConfiguration((ServletContext)context.getServletContext());
                configuration.getFactory().getPolicy().setMaxTextMessageSize(0xA00000);
                configuration.addMapping("/info/*", infoCreator);
                context.addBean((Object)configuration, true);
                FilterHolder wsufHolder = new FilterHolder((Filter)new WebSocketUpgradeFilter(configuration));
                context.addFilter(wsufHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
                server.start();
                return server;
            }
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf.configureContext/ServletContextListener configure", () -> {
            Server server14 = new Server();
            ServerConnector connector = new ServerConnector(server14);
            connector.setPort(0);
            server14.addConnector((Connector)connector);
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            server14.setHandler((Handler)context);
            context.addFilter(WebSocketUpgradeFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.addEventListener((EventListener)((Object)new InfoContextListener()));
            server14.start();
            return server14;
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf/WebAppContext/web.xml/ServletContextListener", () -> {
            File testDir = WebSocketUpgradeFilterTest.getNewTestDir();
            WSServer server15 = new WSServer(testDir, "/");
            server15.copyWebInf("wsuf-config-via-listener.xml");
            server15.copyClass(InfoSocket.class);
            server15.copyClass(InfoContextAttributeListener.class);
            server15.start();
            WebAppContext webapp = server15.createWebAppContext();
            server15.deployWebapp(webapp);
            return server15.getServer();
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf/WebAppContext/web.xml/ServletContextListener/jetty-http.jar", new ServerProvider(){

            @Override
            public Server newServer() throws Exception {
                File testDir = WebSocketUpgradeFilterTest.getNewTestDir();
                WSServer server = new WSServer(testDir, "/");
                server.copyWebInf("wsuf-config-via-listener.xml");
                server.copyClass(InfoSocket.class);
                server.copyClass(InfoContextAttributeListener.class);
                server.copyLib(PathSpec.class, "jetty-http-9.99.999.jar");
                server.start();
                WebAppContext webapp = server.createWebAppContext();
                server.deployWebapp(webapp);
                return server.getServer();
            }
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf/WebAppContext/web.xml/Servlet.init", () -> {
            File testDir = WebSocketUpgradeFilterTest.getNewTestDir();
            WSServer server16 = new WSServer(testDir, "/");
            server16.copyWebInf("wsuf-config-via-servlet-init.xml");
            server16.copyClass(InfoSocket.class);
            server16.copyClass(InfoServlet.class);
            server16.start();
            WebAppContext webapp = server16.createWebAppContext();
            server16.deployWebapp(webapp);
            return server16.getServer();
        }}));
        cases.add(Arguments.of((Object[])new Object[]{"wsuf/WebAppContext/web.xml/ServletContextListener/alt-config", () -> {
            File testDir = WebSocketUpgradeFilterTest.getNewTestDir();
            WSServer server17 = new WSServer(testDir, "/");
            server17.copyWebInf("wsuf-alt-config-via-listener.xml");
            server17.copyClass(InfoSocket.class);
            server17.copyClass(InfoContextAltAttributeListener.class);
            server17.start();
            WebAppContext webapp = server17.createWebAppContext();
            server17.deployWebapp(webapp);
            return server17.getServer();
        }}));
        return cases.stream();
    }

    private void startServer(ServerProvider serverProvider) throws Exception {
        this.server = serverProvider.newServer();
        ServerConnector connector = (ServerConnector)this.server.getConnectors()[0];
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        this.serverUri = new URI(String.format("ws://%s:%d/", host, port));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"scenarios"})
    public void testNormalConfiguration(String testId, ServerProvider serverProvider) throws Exception {
        this.startServer(serverProvider);
        URI destUri = this.serverUri.resolve("/info/");
        BlockheadClientRequest request = client.newWsRequest(destUri);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("hello"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame received = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            String payload = received.getPayloadAsUTF8();
            MatcherAssert.assertThat((String)"payload", (Object)payload, (Matcher)Matchers.containsString((String)"session.maxTextMessageSize=10485760"));
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"scenarios"})
    public void testStopStartOfHandler(String testId, ServerProvider serverProvider) throws Exception {
        String payload;
        WebSocketFrame received;
        LinkedBlockingQueue frames;
        this.startServer(serverProvider);
        URI destUri = this.serverUri.resolve("/info/");
        BlockheadClientRequest request = client.newWsRequest(destUri);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("hello 1"));
            frames = clientConn.getFrameQueue();
            received = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            payload = received.getPayloadAsUTF8();
            MatcherAssert.assertThat((String)"payload", (Object)payload, (Matcher)Matchers.containsString((String)"session.maxTextMessageSize=10485760"));
        }
        this.server.getHandler().stop();
        this.server.getHandler().start();
        request = client.newWsRequest(destUri);
        connFut = request.sendAsync();
        clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);
        try {
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("hello 2"));
            frames = clientConn.getFrameQueue();
            received = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            payload = received.getPayloadAsUTF8();
            MatcherAssert.assertThat((String)"payload", (Object)payload, (Matcher)Matchers.containsString((String)"session.maxTextMessageSize=10485760"));
        }
        finally {
            if (clientConn != null) {
                clientConn.close();
            }
        }
    }

    static {
        uniqTestDirId = new AtomicInteger(0);
    }

    static interface ServerProvider {
        public Server newServer() throws Exception;
    }
}

