/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.util.TextUtil;

@WebSocket
public class ABSocket {
    private static Logger LOG = Log.getLogger(ABSocket.class);
    private Session session;

    @OnWebSocketMessage
    public void onBinary(byte[] buf, int offset, int len) {
        LOG.debug("onBinary(byte[{}],{},{})", new Object[]{buf.length, offset, len});
        ByteBuffer data = ByteBuffer.wrap(buf, offset, len);
        this.session.getRemote().sendBytes(data, null);
    }

    @OnWebSocketConnect
    public void onOpen(Session sess) {
        this.session = sess;
    }

    @OnWebSocketMessage
    public void onText(String message) {
        if (LOG.isDebugEnabled()) {
            if (message == null) {
                LOG.debug("onText() msg=null", new Object[0]);
            } else {
                LOG.debug("onText() size={}, msg={}", new Object[]{message.length(), TextUtil.hint((String)message)});
            }
        }
        try {
            this.session.getRemote().sendString(message, null);
        }
        catch (WebSocketException e) {
            LOG.warn("Unable to echo TEXT message", (Throwable)e);
        }
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onError", cause);
        }
    }
}

