/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.RawFrameBuilder;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.ab.ABServlet;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractABCase
implements Fuzzed {
    protected static final byte FIN = -128;
    protected static final byte NOFIN = 0;
    protected static final byte[] MASK = new byte[]{18, 52, 86, 120};
    protected Generator strictGenerator;
    protected Generator laxGenerator;
    protected static SimpleServletServer server;
    public ByteBufferPool bufferPool = new MappedByteBufferPool();

    @BeforeEach
    public void initGenerators() {
        WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
        this.strictGenerator = new Generator(policy, this.bufferPool, true);
        this.laxGenerator = new Generator(policy, this.bufferPool, false);
    }

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new ABServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    protected ByteBuffer copyOf(byte[] payload) {
        return ByteBuffer.wrap(Arrays.copyOf(payload, payload.length));
    }

    protected ByteBuffer clone(ByteBuffer payload) {
        ByteBuffer copy = ByteBuffer.allocate(payload.remaining());
        copy.put(payload.slice());
        copy.flip();
        return copy;
    }

    protected ByteBuffer copyOf(ByteBuffer payload) {
        ByteBuffer copy = ByteBuffer.allocate(payload.remaining());
        BufferUtil.clearToFill((ByteBuffer)copy);
        BufferUtil.put((ByteBuffer)payload, (ByteBuffer)copy);
        BufferUtil.flipToFlush((ByteBuffer)copy, (int)0);
        return copy;
    }

    public static String toUtf8String(byte[] buf) {
        String raw = StringUtil.toUTF8String((byte[])buf, (int)0, (int)buf.length);
        StringBuilder ret = new StringBuilder();
        int len = raw.length();
        for (int i = 0; i < len; ++i) {
            int codepoint = raw.codePointAt(i);
            if (Character.isUnicodeIdentifierPart(codepoint)) {
                ret.append(String.format("\\u%04X", codepoint));
                continue;
            }
            ret.append(Character.toChars(codepoint));
        }
        return ret.toString();
    }

    @Deprecated
    protected void enableStacks(Class<?> clazz, boolean enabled) {
        StdErrLog log = StdErrLog.getLogger(clazz);
        log.setHideStacks(!enabled);
    }

    public Generator getLaxGenerator() {
        return this.laxGenerator;
    }

    public SimpleServletServer getServer() {
        return server;
    }

    public URI getServerURI() {
        return server.getServerUri();
    }

    public static byte[] masked(byte[] data) {
        return RawFrameBuilder.mask((byte[])data, (byte[])MASK);
    }

    public static void putLength(ByteBuffer buf, int length, boolean masked) {
        RawFrameBuilder.putLength((ByteBuffer)buf, (int)length, (boolean)masked);
    }

    public static void putMask(ByteBuffer buf) {
        buf.put(MASK);
    }

    public static void putPayloadLength(ByteBuffer buf, int length) {
        AbstractABCase.putLength(buf, length, true);
    }

    protected static class BadFrame
    extends WebSocketFrame {
        public BadFrame(byte opcode) {
            super((byte)0);
            this.finRsvOp = (byte)(this.finRsvOp & 0xF0 | opcode & 0xF);
        }

        public void assertValid() {
        }

        public boolean isControlFrame() {
            return false;
        }

        public boolean isDataFrame() {
            return false;
        }
    }
}

