/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase1
extends AbstractABCase {
    @Test
    public void testCase1_1_1() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame());
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame());
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_2() throws Exception {
        byte[] payload = new byte[125];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_3() throws Exception {
        byte[] payload = new byte[126];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_4() throws Exception {
        byte[] payload = new byte[127];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_5() throws Exception {
        byte[] payload = new byte[128];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_6() throws Exception {
        byte[] payload = new byte[65535];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_7() throws Exception {
        byte[] payload = new byte[65536];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_1_8() throws Exception {
        byte[] payload = new byte[65536];
        Arrays.fill(payload, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        int segmentSize = 997;
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(segmentSize);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_1() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame());
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame());
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_2() throws Exception {
        byte[] payload = new byte[125];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_3() throws Exception {
        byte[] payload = new byte[126];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_4() throws Exception {
        byte[] payload = new byte[127];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_5() throws Exception {
        byte[] payload = new byte[128];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_6() throws Exception {
        byte[] payload = new byte[65535];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_7() throws Exception {
        byte[] payload = new byte[65536];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase1_2_8() throws Exception {
        byte[] payload = new byte[65536];
        Arrays.fill(payload, (byte)-2);
        ByteBuffer buf = ByteBuffer.wrap(payload);
        int segmentSize = 997;
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(segmentSize);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }
}

