/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase2
extends AbstractABCase {
    @Test
    public void testCase2_1() throws Exception {
        PingFrame send = new PingFrame();
        PongFrame expect = new PongFrame();
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send((WebSocketFrame)send);
            fuzzer.expect((WebSocketFrame)expect);
        }
    }

    @Test
    public void testCase2_10() throws Exception {
        int pingCount = 10;
        ArrayList<Object> send = new ArrayList<Object>();
        ArrayList<Object> expect = new ArrayList<Object>();
        for (int i = 0; i < pingCount; ++i) {
            String payload = String.format("ping-%d[%X]", i, i);
            send.add(new PingFrame().setPayload(payload));
            expect.add(new PongFrame().setPayload(payload));
        }
        send.add(new CloseInfo(1000).asFrame());
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_11() throws Exception {
        int pingCount = 10;
        ArrayList<Object> send = new ArrayList<Object>();
        ArrayList<Object> expect = new ArrayList<Object>();
        for (int i = 0; i < pingCount; ++i) {
            String payload = String.format("ping-%d[%X]", i, i);
            send.add(new PingFrame().setPayload(payload));
            expect.add(new PongFrame().setPayload(payload));
        }
        send.add(new CloseInfo(1000).asFrame());
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(5);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_2() throws Exception {
        byte[] payload = StringUtil.getUtf8Bytes((String)"Hello world");
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PingFrame().setPayload(payload));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload(this.copyOf(payload)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_3() throws Exception {
        byte[] payload = new byte[]{0, -1, -2, -3, -4, -5, 0, -1};
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PingFrame().setPayload(payload));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload(this.copyOf(payload)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_4() throws Exception {
        byte[] payload = new byte[125];
        Arrays.fill(payload, (byte)-2);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PingFrame().setPayload(payload));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload(this.copyOf(payload)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_5() throws Exception {
        try (StacklessLogging scope = new StacklessLogging(new Class[]{Parser.class});){
            byte[] payload = new byte[126];
            Arrays.fill(payload, (byte)53);
            ByteBuffer buf = ByteBuffer.wrap(payload);
            ArrayList<Object> send = new ArrayList<Object>();
            send.add(new AbstractABCase.BadFrame(9).setPayload(buf));
            send.add(new CloseInfo(1000, "Test 2.5").asFrame());
            ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
            expect.add(new CloseInfo(1002).asFrame());
            try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
                fuzzer.connect();
                fuzzer.setSendMode(Fuzzer.SendMode.BULK);
                fuzzer.send(send);
                fuzzer.expect(expect);
            }
        }
    }

    @Test
    public void testCase2_6() throws Exception {
        byte[] payload = new byte[125];
        Arrays.fill(payload, (byte)54);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PingFrame().setPayload(payload));
        send.add(new CloseInfo(1000, "Test 2.6").asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload(this.copyOf(payload)));
        expect.add(new CloseInfo(1000, "Test 2.6").asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_7() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PongFrame());
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_8() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PongFrame().setPayload("unsolicited"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase2_9() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PongFrame().setPayload("unsolicited"));
        send.add(new PingFrame().setPayload("our ping"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload("our ping"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }
}

