/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase3
extends AbstractABCase {
    @Test
    public void testCase3_1() throws Exception {
        WebSocketFrame send = new TextFrame().setPayload("small").setRsv1(true);
        CloseFrame expect = new CloseInfo(1002).asFrame();
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect((WebSocketFrame)expect);
        }
    }

    @Test
    public void testCase3_2() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("small"));
        send.add(new TextFrame().setPayload("small").setRsv2(true));
        send.add(new PingFrame().setPayload("ping"));
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("small"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase3_3() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("small"));
        send.add(new TextFrame().setPayload("small").setRsv1(true).setRsv2(true));
        send.add(new PingFrame().setPayload("ping"));
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("small"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase3_4() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("small"));
        send.add(new TextFrame().setPayload("small").setRsv3(true));
        send.add(new PingFrame().setPayload("ping"));
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("small"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase3_5() throws Exception {
        byte[] payload = new byte[8];
        Arrays.fill(payload, (byte)-1);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new BinaryFrame().setPayload(payload).setRsv3(true).setRsv1(true));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase3_6() throws Exception {
        byte[] payload = new byte[8];
        Arrays.fill(payload, (byte)-1);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new PingFrame().setPayload(payload).setRsv3(true).setRsv2(true));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase3_7() throws Exception {
        byte[] payload = new byte[8];
        Arrays.fill(payload, (byte)-1);
        ArrayList<CloseFrame> send = new ArrayList<CloseFrame>();
        CloseFrame frame = new CloseInfo(1000).asFrame();
        frame.setRsv1(true);
        frame.setRsv2(true);
        frame.setRsv3(true);
        send.add(frame);
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }
}

