/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase4
extends AbstractABCase {
    @Test
    public void testCase4_1_1() throws Exception {
        ArrayList<AbstractABCase.BadFrame> send = new ArrayList<AbstractABCase.BadFrame>();
        send.add(new AbstractABCase.BadFrame(3));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_1_2() throws Exception {
        byte[] payload = StringUtil.getUtf8Bytes((String)"reserved payload");
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new AbstractABCase.BadFrame(4).setPayload(buf));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_1_3() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello"));
        send.add((Object)new AbstractABCase.BadFrame(5));
        send.add(new PingFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_1_4() throws Exception {
        ByteBuffer buf = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)"bad"));
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello"));
        send.add(new AbstractABCase.BadFrame(6).setPayload(buf));
        send.add(new PingFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_1_5() throws Exception {
        ByteBuffer buf = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)"bad"));
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello"));
        send.add(new AbstractABCase.BadFrame(7).setPayload(buf));
        send.add(new PingFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_2_1() throws Exception {
        ArrayList<AbstractABCase.BadFrame> send = new ArrayList<AbstractABCase.BadFrame>();
        send.add(new AbstractABCase.BadFrame(11));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_2_2() throws Exception {
        ByteBuffer buf = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)"bad"));
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new AbstractABCase.BadFrame(12).setPayload(buf));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_2_3() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello"));
        send.add((Object)new AbstractABCase.BadFrame(13));
        send.add(new PingFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_2_4() throws Exception {
        ByteBuffer buf = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)"bad"));
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello"));
        send.add(new AbstractABCase.BadFrame(14).setPayload(buf));
        send.add(new PingFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase4_2_5() throws Exception {
        ByteBuffer buf = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)"bad"));
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello"));
        send.add(new AbstractABCase.BadFrame(15).setPayload(buf));
        send.add(new PingFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }
}

