/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase5
extends AbstractABCase {
    @Test
    public void testCase5_1() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PingFrame().setPayload("hello, ").setFin(false));
        send.add(new ContinuationFrame().setPayload("world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_10() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("sorry").setFin(true));
        send.add(new TextFrame().setPayload("hello, world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.sendAndIgnoreBrokenPipe(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_11() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("sorry").setFin(true));
        send.add(new TextFrame().setPayload("hello, world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.sendAndIgnoreBrokenPipe(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_12() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("sorry").setFin(false));
        send.add(new TextFrame().setPayload("hello, world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.sendAndIgnoreBrokenPipe(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_13() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("sorry").setFin(false));
        send.add(new TextFrame().setPayload("hello, world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.sendAndIgnoreBrokenPipe(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_14() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("sorry").setFin(false));
        send.add(new TextFrame().setPayload("hello, world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.sendAndIgnoreBrokenPipe(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_15() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("fragment1").setFin(false));
        send.add(new ContinuationFrame().setPayload("fragment2").setFin(true));
        send.add(new ContinuationFrame().setPayload("fragment3").setFin(false));
        send.add(new TextFrame().setPayload("fragment4").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("fragment1fragment2"));
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_16() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("fragment1").setFin(false));
        send.add(new TextFrame().setPayload("fragment2").setFin(false));
        send.add(new ContinuationFrame().setPayload("fragment3").setFin(true));
        send.add(new ContinuationFrame().setPayload("fragment4").setFin(false));
        send.add(new TextFrame().setPayload("fragment5").setFin(false));
        send.add(new ContinuationFrame().setPayload("fragment6").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.sendAndIgnoreBrokenPipe(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_17() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("fragment1").setFin(true));
        send.add(new TextFrame().setPayload("fragment2").setFin(false));
        send.add(new ContinuationFrame().setPayload("fragment3").setFin(true));
        send.add(new ContinuationFrame().setPayload("fragment4").setFin(true));
        send.add(new TextFrame().setPayload("fragment5").setFin(false));
        send.add(new ContinuationFrame().setPayload("fragment6").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_18() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("fragment1").setFin(false));
        send.add(new TextFrame().setPayload("fragment2").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_19() throws Exception {
        ArrayList<Object> send1 = new ArrayList<Object>();
        send1.add(new TextFrame().setPayload("f1").setFin(false));
        send1.add(new ContinuationFrame().setPayload(",f2").setFin(false));
        send1.add(new PingFrame().setPayload("pong-1"));
        ArrayList<PongFrame> expect1 = new ArrayList<PongFrame>();
        expect1.add(new PongFrame().setPayload("pong-1"));
        ArrayList<Object> send2 = new ArrayList<Object>();
        send2.add(new ContinuationFrame().setPayload(",f3").setFin(false));
        send2.add(new ContinuationFrame().setPayload(",f4").setFin(false));
        send2.add(new PingFrame().setPayload("pong-2"));
        send2.add(new ContinuationFrame().setPayload(",f5").setFin(true));
        send2.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect2 = new ArrayList<Object>();
        expect2.add(new PongFrame().setPayload("pong-2"));
        expect2.add(new TextFrame().setPayload("f1,f2,f3,f4,f5"));
        expect2.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send1);
            fuzzer.expect(expect1);
            TimeUnit.SECONDS.sleep(1L);
            fuzzer.send(send2);
            fuzzer.expect(expect2);
        }
    }

    @Test
    public void testCase5_2() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new PongFrame().setPayload("hello, ").setFin(false));
        send.add(new ContinuationFrame().setPayload("world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_20() throws Exception {
        ArrayList<Object> send1 = new ArrayList<Object>();
        send1.add(new TextFrame().setPayload("f1").setFin(false));
        send1.add(new ContinuationFrame().setPayload(",f2").setFin(false));
        send1.add(new PingFrame().setPayload("pong-1"));
        ArrayList<Object> send2 = new ArrayList<Object>();
        send2.add(new ContinuationFrame().setPayload(",f3").setFin(false));
        send2.add(new ContinuationFrame().setPayload(",f4").setFin(false));
        send2.add(new PingFrame().setPayload("pong-2"));
        send2.add(new ContinuationFrame().setPayload(",f5").setFin(true));
        send2.add(new CloseInfo(1000).asFrame());
        ArrayList<PongFrame> expect1 = new ArrayList<PongFrame>();
        expect1.add(new PongFrame().setPayload("pong-1"));
        ArrayList<Object> expect2 = new ArrayList<Object>();
        expect2.add(new PongFrame().setPayload("pong-2"));
        expect2.add(new TextFrame().setPayload("f1,f2,f3,f4,f5"));
        expect2.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.send(send1);
            fuzzer.expect(expect1);
            TimeUnit.SECONDS.sleep(1L);
            fuzzer.send(send2);
            fuzzer.expect(expect2);
        }
    }

    @Test
    public void testCase5_20_slow() throws Exception {
        ArrayList<Object> send1 = new ArrayList<Object>();
        send1.add(new TextFrame().setPayload("f1").setFin(false));
        send1.add(new ContinuationFrame().setPayload(",f2").setFin(false));
        send1.add(new PingFrame().setPayload("pong-1"));
        ArrayList<Object> send2 = new ArrayList<Object>();
        send2.add(new ContinuationFrame().setPayload(",f3").setFin(false));
        send2.add(new ContinuationFrame().setPayload(",f4").setFin(false));
        send2.add(new PingFrame().setPayload("pong-2"));
        send2.add(new ContinuationFrame().setPayload(",f5").setFin(true));
        send2.add(new CloseInfo(1000).asFrame());
        ArrayList<PongFrame> expect1 = new ArrayList<PongFrame>();
        expect1.add(new PongFrame().setPayload("pong-1"));
        ArrayList<Object> expect2 = new ArrayList<Object>();
        expect2.add(new PongFrame().setPayload("pong-2"));
        expect2.add(new TextFrame().setPayload("f1,f2,f3,f4,f5"));
        expect2.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.send(send1);
            fuzzer.expect(expect1);
            TimeUnit.SECONDS.sleep(1L);
            fuzzer.send(send2);
            fuzzer.expect(expect2);
        }
    }

    @Test
    public void testCase5_3() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello, ").setFin(false));
        send.add(new ContinuationFrame().setPayload("world").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello, world"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_4() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello, ").setFin(false));
        send.add(new ContinuationFrame().setPayload("world").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello, world"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_5() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello, ").setFin(false));
        send.add(new ContinuationFrame().setPayload("world").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("hello, world"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_6() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello, ").setFin(false));
        send.add(new PingFrame().setPayload("ping"));
        send.add(new ContinuationFrame().setPayload("world").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload("ping"));
        expect.add(new TextFrame().setPayload("hello, world"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_7() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello, ").setFin(false));
        send.add(new PingFrame().setPayload("ping"));
        send.add(new ContinuationFrame().setPayload("world").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload("ping"));
        expect.add(new TextFrame().setPayload("hello, world"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_8() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("hello, ").setFin(false));
        send.add(new PingFrame().setPayload("ping"));
        send.add(new ContinuationFrame().setPayload("world").setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new PongFrame().setPayload("ping"));
        expect.add(new TextFrame().setPayload("hello, world"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(1);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase5_9() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new ContinuationFrame().setPayload("sorry").setFin(true));
        send.add(new TextFrame().setPayload("hello, world"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }
}

