/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase6
extends AbstractABCase {
    protected void fragmentText(List<WebSocketFrame> frames, byte[] msg) {
        int len = msg.length;
        boolean continuation = false;
        for (int i = 0; i < len; ++i) {
            Object frame = null;
            frame = continuation ? new ContinuationFrame() : new TextFrame();
            byte[] mini = new byte[]{msg[i]};
            frame.setPayload(ByteBuffer.wrap(mini));
            boolean isLast = i >= len - 1;
            frame.setFin(isLast);
            frames.add((WebSocketFrame)frame);
            continuation = true;
        }
    }

    @Test
    public void testCase6_1_1() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame());
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame());
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_1_2() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setFin(false));
        send.add(new ContinuationFrame().setFin(false));
        send.add(new ContinuationFrame().setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame());
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_1_3() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setFin(false));
        send.add(new ContinuationFrame().setPayload("middle").setFin(false));
        send.add(new ContinuationFrame().setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("middle"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_2_2() throws Exception {
        String utf1 = "Hello-\uc2b5@\uc39f\uc3a4";
        String utf2 = "\uc3bc\uc3a0\uc3a1-UTF-8!!";
        ByteBuffer b1 = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)utf1));
        ByteBuffer b2 = ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)utf2));
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(b1).setFin(false));
        send.add(new ContinuationFrame().setPayload(b2).setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        ByteBuffer e1 = ByteBuffer.allocate(100);
        e1.put(StringUtil.getUtf8Bytes((String)utf1));
        e1.put(StringUtil.getUtf8Bytes((String)utf2));
        e1.flip();
        expect.add(new TextFrame().setPayload(e1));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_2_3() throws Exception {
        String utf8 = "Hello-\uc2b5@\uc39f\uc3a4\uc3bc\uc3a0\uc3a1-UTF-8!!";
        byte[] msg = StringUtil.getUtf8Bytes((String)utf8);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        this.fragmentText(send, msg);
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(ByteBuffer.wrap(msg)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_2_4() throws Exception {
        byte[] msg = Hex.asByteArray((String)"CEBAE1BDB9CF83CEBCCEB5");
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        this.fragmentText(send, msg);
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(ByteBuffer.wrap(msg)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_3_2() throws Exception {
        byte[] invalid = Hex.asByteArray((String)"CEBAE1BDB9CF83CEBCCEB5EDA080656469746564");
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        this.fragmentText(send, invalid);
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1007).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_4_1() throws Exception {
        byte[] part1 = StringUtil.getUtf8Bytes((String)"\u03ba\u1f79\u03c3\u03bc\u03b5");
        byte[] part2 = Hex.asByteArray((String)"F4908080");
        byte[] part3 = StringUtil.getUtf8Bytes((String)"edited");
        ByteBuffer b1 = ByteBuffer.wrap(part1);
        ByteBuffer b2 = ByteBuffer.wrap(part2);
        ByteBuffer b3 = ByteBuffer.wrap(part3);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(b1).setFin(false));
        send.add(new ContinuationFrame().setPayload(b2).setFin(true));
        send.add(new ContinuationFrame().setPayload(b3).setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1007).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_4_2() throws Exception {
        byte[] part1 = Hex.asByteArray((String)"CEBAE1BDB9CF83CEBCCEB5F4");
        byte[] part2 = Hex.asByteArray((String)"90");
        byte[] part3 = Hex.asByteArray((String)"8080656469746564");
        ByteBuffer b1 = ByteBuffer.wrap(part1);
        ByteBuffer b2 = ByteBuffer.wrap(part2);
        ByteBuffer b3 = ByteBuffer.wrap(part3);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(b1).setFin(false));
        send.add(new ContinuationFrame().setPayload(b2).setFin(true));
        send.add(new ContinuationFrame().setPayload(b3).setFin(true));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1007).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.PER_FRAME);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase6_4_3() throws Exception {
        try (StacklessLogging scope = new StacklessLogging(new Class[]{Parser.class});){
            ByteBuffer payload = ByteBuffer.allocate(64);
            BufferUtil.clearToFill((ByteBuffer)payload);
            payload.put(TypeUtil.fromHexString((String)"cebae1bdb9cf83cebcceb5"));
            payload.put(TypeUtil.fromHexString((String)"f4908080"));
            payload.put(TypeUtil.fromHexString((String)"656469746564"));
            BufferUtil.flipToFlush((ByteBuffer)payload, (int)0);
            ArrayList<Object> send = new ArrayList<Object>();
            send.add(new TextFrame().setPayload(payload));
            send.add(new CloseInfo(1000).asFrame());
            ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
            expect.add(new CloseInfo(1007).asFrame());
            try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
                fuzzer.connect();
                ByteBuffer net = fuzzer.asNetworkBuffer(send);
                int[] splits = new int[]{17, 21, net.limit()};
                ByteBuffer part1 = net.slice();
                part1.limit(splits[0]);
                ByteBuffer part2 = net.slice();
                part2.position(splits[0]);
                part2.limit(splits[1]);
                ByteBuffer part3 = net.slice();
                part3.position(splits[1]);
                part3.limit(splits[2]);
                fuzzer.send(part1);
                fuzzer.send(part2);
                fuzzer.send(part3);
                fuzzer.expect(expect);
            }
        }
    }

    @Test
    public void testCase6_4_4() throws Exception {
        byte[] invalid = Hex.asByteArray((String)"CEBAE1BDB9CF83CEBCCEB5F49080808080656469746564");
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(ByteBuffer.wrap(invalid)));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1007).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging scope = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            ByteBuffer net = fuzzer.asNetworkBuffer(send);
            fuzzer.send(net, 6);
            fuzzer.send(net, 11);
            fuzzer.send(net, 1);
            fuzzer.send(net, 100);
            fuzzer.expect(expect);
        }
    }
}

