/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestABCase6_GoodUTF
extends AbstractABCase {
    private static final Logger LOG = Log.getLogger(TestABCase6_GoodUTF.class);

    public static Stream<Arguments> utfSequences() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"6.2.1", "48656C6C6F2DC2B540C39FC3B6C3A4C3BCC3A0C3A12D5554462D382121"});
        data.add(new String[]{"6.5.1", "CEBAE1BDB9CF83CEBCCEB5"});
        data.add(new String[]{"6.6.11", "CEBAE1BDB9CF83CEBCCEB5"});
        data.add(new String[]{"6.6.2", "CEBA"});
        data.add(new String[]{"6.6.5", "CEBAE1BDB9"});
        data.add(new String[]{"6.6.7", "CEBAE1BDB9CF83"});
        data.add(new String[]{"6.6.9", "CEBAE1BDB9CF83CEBC"});
        data.add(new String[]{"6.7.1", "00"});
        data.add(new String[]{"6.7.2", "C280"});
        data.add(new String[]{"6.7.3", "E0A080"});
        data.add(new String[]{"6.7.4", "F0908080"});
        data.add(new String[]{"6.9.1", "7F"});
        data.add(new String[]{"6.9.2", "DFBF"});
        data.add(new String[]{"6.9.3", "EFBFBF"});
        data.add(new String[]{"6.9.4", "F48FBFBF"});
        data.add(new String[]{"6.11.1", "ED9FBF"});
        data.add(new String[]{"6.11.2", "EE8080"});
        data.add(new String[]{"6.11.3", "EFBFBD"});
        data.add(new String[]{"6.11.4", "F48FBFBF"});
        data.add(new String[]{"6.22.1", "EFBFBE"});
        data.add(new String[]{"6.22.2", "EFBFBF"});
        data.add(new String[]{"6.22.3", "F09FBFBE"});
        data.add(new String[]{"6.22.4", "F09FBFBF"});
        data.add(new String[]{"6.22.5", "F0AFBFBE"});
        data.add(new String[]{"6.22.6", "F0AFBFBF"});
        data.add(new String[]{"6.22.7", "F0BFBFBE"});
        data.add(new String[]{"6.22.8", "F0BFBFBF"});
        data.add(new String[]{"6.22.9", "F18FBFBE"});
        data.add(new String[]{"6.22.10", "F18FBFBF"});
        data.add(new String[]{"6.22.11", "F19FBFBE"});
        data.add(new String[]{"6.22.12", "F19FBFBF"});
        data.add(new String[]{"6.22.13", "F1AFBFBE"});
        data.add(new String[]{"6.22.14", "F1AFBFBF"});
        data.add(new String[]{"6.22.15", "F1BFBFBE"});
        data.add(new String[]{"6.22.16", "F1BFBFBF"});
        data.add(new String[]{"6.22.17", "F28FBFBE"});
        data.add(new String[]{"6.22.18", "F28FBFBF"});
        data.add(new String[]{"6.22.19", "F29FBFBE"});
        data.add(new String[]{"6.22.20", "F29FBFBF"});
        data.add(new String[]{"6.22.21", "F2AFBFBE"});
        data.add(new String[]{"6.22.22", "F2AFBFBF"});
        data.add(new String[]{"6.22.23", "F2BFBFBE"});
        data.add(new String[]{"6.22.24", "F2BFBFBF"});
        data.add(new String[]{"6.22.25", "F38FBFBE"});
        data.add(new String[]{"6.22.26", "F38FBFBF"});
        data.add(new String[]{"6.22.27", "F39FBFBE"});
        data.add(new String[]{"6.22.28", "F39FBFBF"});
        data.add(new String[]{"6.22.29", "F3AFBFBE"});
        data.add(new String[]{"6.22.30", "F3AFBFBF"});
        data.add(new String[]{"6.22.31", "F3BFBFBE"});
        data.add(new String[]{"6.22.32", "F3BFBFBF"});
        data.add(new String[]{"6.22.33", "F48FBFBE"});
        data.add(new String[]{"6.22.34", "F48FBFBF"});
        data.add(new String[]{"6.23.1", "EFBFBD"});
        return data.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"utfSequences"})
    public void assertEchoTextMessage(String testId, String hexMsg) throws Exception {
        ByteBuffer msg = Hex.asByteBuffer((String)hexMsg);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(msg));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(msg)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }
}

