/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase7
extends AbstractABCase {
    @Test
    public void testCase7_1_1() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("Hello World"));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload("Hello World"));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase7_1_2() throws Exception {
        ArrayList<CloseFrame> send = new ArrayList<CloseFrame>();
        send.add(new CloseInfo(1000).asFrame());
        send.add(new CloseInfo().asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_1_3() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new CloseInfo(1000).asFrame());
        send.add(new PingFrame().setPayload("out of band ping"));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_1_4() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new CloseInfo(1000).asFrame());
        send.add(new TextFrame().setPayload("out of band text"));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_1_5() throws Exception {
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload("an").setFin(false));
        send.add(new CloseInfo(1000).asFrame());
        send.add(new ContinuationFrame().setPayload("ticipation").setFin(true));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_1_6() throws Exception {
        byte[] msg = new byte[262144];
        Arrays.fill(msg, (byte)42);
        ByteBuffer buf = ByteBuffer.wrap(msg);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        send.add(new PingFrame().setPayload("out of band"));
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_3_1() throws Exception {
        ArrayList<CloseFrame> send = new ArrayList<CloseFrame>();
        send.add(new CloseFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_3_2() throws Exception {
        byte[] payload = new byte[]{0};
        ByteBuffer buf = ByteBuffer.wrap(payload);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new CloseFrame().setPayload(buf));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging scope = new StacklessLogging(new Class[]{Parser.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_3_3() throws Exception {
        ArrayList<CloseFrame> send = new ArrayList<CloseFrame>();
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_3_4() throws Exception {
        ArrayList<CloseFrame> send = new ArrayList<CloseFrame>();
        send.add(new CloseInfo(1000, "Hic").asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000, "Hic").asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_3_5() throws Exception {
        byte[] utf = new byte[123];
        Arrays.fill(utf, (byte)33);
        String reason = StringUtil.toUTF8String((byte[])utf, (int)0, (int)utf.length);
        ArrayList<CloseFrame> send = new ArrayList<CloseFrame>();
        send.add(new CloseInfo(1000, reason).asFrame());
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1000, reason).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging logging = new StacklessLogging(new Class[]{AbstractWebSocketConnection.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @Test
    public void testCase7_5_1() throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(256);
        BufferUtil.clearToFill((ByteBuffer)payload);
        payload.put((byte)3);
        payload.put((byte)-24);
        byte[] invalidUtf = Hex.asByteArray((String)"CEBAE1BDB9CF83CEBCCEB5EDA080656469746564");
        payload.put(invalidUtf);
        BufferUtil.flipToFlush((ByteBuffer)payload, (int)0);
        ArrayList<AbstractABCase.BadFrame> send = new ArrayList<AbstractABCase.BadFrame>();
        AbstractABCase.BadFrame close = new AbstractABCase.BadFrame(8);
        close.setPayload(payload);
        send.add(close);
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1007).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);
             StacklessLogging scope = new StacklessLogging(new Class[]{Parser.class, CloseInfo.class});){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }
}

