/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.eclipse.jetty.websocket.server.ab.TestABCase7_GoodStatusCodes;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestABCase7_BadStatusCodes
extends AbstractABCase {
    private static final Logger LOG = Log.getLogger(TestABCase7_GoodStatusCodes.class);

    public static Stream<Arguments> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"7.9.1", 0});
        data.add(new Object[]{"7.9.2", 999});
        data.add(new Object[]{"7.9.3", 1004});
        data.add(new Object[]{"7.9.4", 1005});
        data.add(new Object[]{"7.9.5", 1006});
        data.add(new Object[]{"7.9.9", 1015});
        data.add(new Object[]{"7.9.10", 1016});
        data.add(new Object[]{"7.9.11", 1100});
        data.add(new Object[]{"7.9.12", 2000});
        data.add(new Object[]{"7.9.13", 2999});
        data.add(new Object[]{"7.13.1", 5000});
        data.add(new Object[]{"7.13.2", 65536});
        return data.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBadStatusCode(String testId, int statusCode) throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(256);
        BufferUtil.clearToFill((ByteBuffer)payload);
        payload.putChar((char)statusCode);
        BufferUtil.flipToFlush((ByteBuffer)payload, (int)0);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new CloseFrame().setPayload(payload.slice()));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBadStatusCodeWithReason(String testId, int statusCode) throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(256);
        BufferUtil.clearToFill((ByteBuffer)payload);
        payload.putChar((char)statusCode);
        payload.put(StringUtil.getBytes((String)"Reason"));
        BufferUtil.flipToFlush((ByteBuffer)payload, (int)0);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new CloseFrame().setPayload(payload.slice()));
        ArrayList<CloseFrame> expect = new ArrayList<CloseFrame>();
        expect.add(new CloseInfo(1002).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }
}

