/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestABCase7_GoodStatusCodes
extends AbstractABCase {
    private static final Logger LOG = Log.getLogger(TestABCase7_GoodStatusCodes.class);

    public static Stream<Arguments> statusCodes() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{"7.7.1", 1000});
        data.add(new Object[]{"7.7.2", 1001});
        data.add(new Object[]{"7.7.3", 1002});
        data.add(new Object[]{"7.7.4", 1003});
        data.add(new Object[]{"7.7.5", 1007});
        data.add(new Object[]{"7.7.6", 1008});
        data.add(new Object[]{"7.7.7", 1009});
        data.add(new Object[]{"7.7.8", 1010});
        data.add(new Object[]{"7.7.9", 1011});
        data.add(new Object[]{"IANA Assigned", 1012});
        data.add(new Object[]{"IANA Assigned", 1013});
        data.add(new Object[]{"IANA Assigned", 1014});
        data.add(new Object[]{"7.7.10", 3000});
        data.add(new Object[]{"7.7.11", 3999});
        data.add(new Object[]{"7.7.12", 4000});
        data.add(new Object[]{"7.7.13", 4999});
        return data.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"statusCodes"})
    public void testStatusCode(String testId, int statusCode) throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(256);
        BufferUtil.clearToFill((ByteBuffer)payload);
        payload.putChar((char)statusCode);
        BufferUtil.flipToFlush((ByteBuffer)payload, (int)0);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new CloseFrame().setPayload(payload.slice()));
        ArrayList<WebSocketFrame> expect = new ArrayList<WebSocketFrame>();
        expect.add(new CloseFrame().setPayload(this.clone(payload)));
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"statusCodes"})
    public void testStatusCodeWithReason(String testId, int statusCode) throws Exception {
        ByteBuffer payload = ByteBuffer.allocate(256);
        payload.putChar((char)statusCode);
        payload.put(StringUtil.getBytes((String)"Reason"));
        payload.flip();
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new CloseFrame().setPayload(payload.slice()));
        ArrayList<WebSocketFrame> expect = new ArrayList<WebSocketFrame>();
        expect.add(new CloseFrame().setPayload(this.clone(payload)));
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
            fuzzer.expectNoMoreFrames();
        }
    }
}

