/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.ab;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.DataFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.Fuzzed;
import org.eclipse.jetty.websocket.common.test.Fuzzer;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.ab.AbstractABCase;
import org.junit.jupiter.api.Test;

public class TestABCase9
extends AbstractABCase {
    private static final int KBYTE = 1024;
    private static final int MBYTE = 0x100000;

    private DataFrame toDataFrame(byte op) {
        switch (op) {
            case 2: {
                return new BinaryFrame();
            }
            case 1: {
                return new TextFrame();
            }
            case 0: {
                return new ContinuationFrame();
            }
        }
        throw new IllegalArgumentException("Not a data frame: " + op);
    }

    private void assertMultiFrameEcho(byte opcode, int overallMsgSize, int fragmentSize) throws Exception {
        byte[] msg = new byte[overallMsgSize];
        Arrays.fill(msg, (byte)77);
        ArrayList<Object> send = new ArrayList<Object>();
        int remaining = msg.length;
        int offset = 0;
        byte op = opcode;
        while (remaining > 0) {
            int len = Math.min(remaining, fragmentSize);
            byte[] frag = new byte[len];
            System.arraycopy(msg, offset, frag, 0, len);
            boolean fin = (remaining -= len) <= 0;
            ByteBuffer buf = ByteBuffer.wrap(frag);
            send.add(this.toDataFrame(op).setPayload(buf).setFin(fin));
            offset += len;
            op = 0;
        }
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(this.toDataFrame(opcode).setPayload(this.copyOf(msg)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 8L, TimeUnit.SECONDS);
        }
    }

    private void assertSlowFrameEcho(byte opcode, int overallMsgSize, int segmentSize) throws Exception {
        byte[] msg = new byte[overallMsgSize];
        Arrays.fill(msg, (byte)77);
        ByteBuffer buf = ByteBuffer.wrap(msg);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(this.toDataFrame(opcode).setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(this.toDataFrame(opcode).setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.SLOW);
            fuzzer.setSlowSendSegmentSize(segmentSize);
            fuzzer.send(send);
            fuzzer.expect(expect, 8L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_1_1() throws Exception {
        byte[] utf = new byte[65536];
        Arrays.fill(utf, (byte)121);
        String msg = StringUtil.toUTF8String((byte[])utf, (int)0, (int)utf.length);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(msg));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(msg));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase9_1_2() throws Exception {
        byte[] utf = new byte[262144];
        Arrays.fill(utf, (byte)121);
        ByteBuffer buf = ByteBuffer.wrap(utf);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 4L, Timeouts.POLL_EVENT_UNIT);
        }
    }

    @Test
    public void testCase9_1_3() throws Exception {
        byte[] utf = new byte[0x100000];
        Arrays.fill(utf, (byte)121);
        ByteBuffer buf = ByteBuffer.wrap(utf);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 4L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_1_4() throws Exception {
        byte[] utf = new byte[0x400000];
        Arrays.fill(utf, (byte)121);
        ByteBuffer buf = ByteBuffer.wrap(utf);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 8L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_1_5() throws Exception {
        byte[] utf = new byte[0x800000];
        Arrays.fill(utf, (byte)121);
        ByteBuffer buf = ByteBuffer.wrap(utf);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 16L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_1_6() throws Exception {
        byte[] utf = new byte[0x1000000];
        Arrays.fill(utf, (byte)121);
        ByteBuffer buf = ByteBuffer.wrap(utf);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new TextFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new TextFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 32L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_2_1() throws Exception {
        byte[] data = new byte[65536];
        Arrays.fill(data, (byte)33);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(data));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.copyOf(data)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase9_2_2() throws Exception {
        byte[] data = new byte[262144];
        Arrays.fill(data, (byte)34);
        ByteBuffer buf = ByteBuffer.wrap(data);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect);
        }
    }

    @Test
    public void testCase9_2_3() throws Exception {
        byte[] data = new byte[0x100000];
        Arrays.fill(data, (byte)35);
        ByteBuffer buf = ByteBuffer.wrap(data);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 4L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_2_4() throws Exception {
        byte[] data = new byte[0x400000];
        Arrays.fill(data, (byte)36);
        ByteBuffer buf = ByteBuffer.wrap(data);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 8L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_2_5() throws Exception {
        byte[] data = new byte[0x800000];
        Arrays.fill(data, (byte)37);
        ByteBuffer buf = ByteBuffer.wrap(data);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 16L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_2_6() throws Exception {
        byte[] data = new byte[0x1000000];
        Arrays.fill(data, (byte)38);
        ByteBuffer buf = ByteBuffer.wrap(data);
        ArrayList<Object> send = new ArrayList<Object>();
        send.add(new BinaryFrame().setPayload(buf));
        send.add(new CloseInfo(1000).asFrame());
        ArrayList<Object> expect = new ArrayList<Object>();
        expect.add(new BinaryFrame().setPayload(this.clone(buf)));
        expect.add(new CloseInfo(1000).asFrame());
        try (Fuzzer fuzzer = new Fuzzer((Fuzzed)this);){
            fuzzer.connect();
            fuzzer.setSendMode(Fuzzer.SendMode.BULK);
            fuzzer.send(send);
            fuzzer.expect(expect, 32L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testCase9_3_1() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 64);
    }

    @Test
    public void testCase9_3_2() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 256);
    }

    @Test
    public void testCase9_3_3() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 1024);
    }

    @Test
    public void testCase9_3_4() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 4096);
    }

    @Test
    public void testCase9_3_5() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 16384);
    }

    @Test
    public void testCase9_3_6() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 65536);
    }

    @Test
    public void testCase9_3_7() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 262144);
    }

    @Test
    public void testCase9_3_8() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 0x100000);
    }

    @Test
    public void testCase9_3_9() throws Exception {
        this.assertMultiFrameEcho((byte)1, 0x400000, 0x400000);
    }

    @Test
    public void testCase9_4_1() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 64);
    }

    @Test
    public void testCase9_4_2() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 256);
    }

    @Test
    public void testCase9_4_3() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 1024);
    }

    @Test
    public void testCase9_4_4() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 4096);
    }

    @Test
    public void testCase9_4_5() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 16384);
    }

    @Test
    public void testCase9_4_6() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 65536);
    }

    @Test
    public void testCase9_4_7() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 262144);
    }

    @Test
    public void testCase9_4_8() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 0x100000);
    }

    @Test
    public void testCase9_4_9() throws Exception {
        this.assertMultiFrameEcho((byte)2, 0x400000, 0x400000);
    }

    @Test
    public void testCase9_5_1() throws Exception {
        this.assertSlowFrameEcho((byte)1, 0x100000, 64);
    }

    @Test
    public void testCase9_5_2() throws Exception {
        this.assertSlowFrameEcho((byte)1, 0x100000, 128);
    }

    @Test
    public void testCase9_5_3() throws Exception {
        this.assertSlowFrameEcho((byte)1, 0x100000, 256);
    }

    @Test
    public void testCase9_5_4() throws Exception {
        this.assertSlowFrameEcho((byte)1, 0x100000, 512);
    }

    @Test
    public void testCase9_5_5() throws Exception {
        this.assertSlowFrameEcho((byte)1, 0x100000, 1024);
    }

    @Test
    public void testCase9_5_6() throws Exception {
        this.assertSlowFrameEcho((byte)1, 0x100000, 2048);
    }

    @Test
    public void testCase9_6_1() throws Exception {
        this.assertSlowFrameEcho((byte)2, 0x100000, 64);
    }

    @Test
    public void testCase9_6_2() throws Exception {
        this.assertSlowFrameEcho((byte)2, 0x100000, 128);
    }

    @Test
    public void testCase9_6_3() throws Exception {
        this.assertSlowFrameEcho((byte)2, 0x100000, 256);
    }

    @Test
    public void testCase9_6_4() throws Exception {
        this.assertSlowFrameEcho((byte)2, 0x100000, 512);
    }

    @Test
    public void testCase9_6_5() throws Exception {
        this.assertSlowFrameEcho((byte)2, 0x100000, 1024);
    }

    @Test
    public void testCase9_6_6() throws Exception {
        this.assertSlowFrameEcho((byte)2, 0x100000, 2048);
    }
}

