/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.browser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.extensions.FrameCaptureExtension;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.server.browser.BrowserSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class BrowserDebugTool
implements WebSocketCreator {
    private static final Logger LOG = Log.getLogger(BrowserDebugTool.class);
    private Server server;
    private ServerConnector connector;

    public static void main(String[] args) {
        int port = 8080;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (!"-p".equals(a) && !"--port".equals(a)) continue;
            port = Integer.parseInt(args[++i]);
        }
        try {
            BrowserDebugTool tool = new BrowserDebugTool();
            tool.prepare(port);
            tool.start();
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        LOG.debug("Creating BrowserSocket", new Object[0]);
        if (req.getSubProtocols() != null && !req.getSubProtocols().isEmpty()) {
            String subProtocol = (String)req.getSubProtocols().get(0);
            resp.setAcceptedSubProtocol(subProtocol);
        }
        String ua = req.getHeader("User-Agent");
        String rexts = req.getHeader("Sec-WebSocket-Extensions");
        ArrayList<ExtensionConfig> negotiated = new ArrayList<ExtensionConfig>();
        negotiated.add(new ExtensionConfig("@frame-capture; output-dir=target"));
        for (ExtensionConfig config : req.getExtensions()) {
            if (!config.getName().equals("permessage-deflate")) continue;
            negotiated.add(config);
        }
        resp.setExtensions(negotiated);
        LOG.debug("User-Agent: {}", new Object[]{ua});
        LOG.debug("Sec-WebSocket-Extensions (Request) : {}", new Object[]{rexts});
        LOG.debug("Sec-WebSocket-Protocol (Request): {}", new Object[]{req.getHeader("Sec-WebSocket-Protocol")});
        LOG.debug("Sec-WebSocket-Protocol (Response): {}", new Object[]{resp.getAcceptedSubProtocol()});
        req.getExtensions();
        return new BrowserSocket(ua, rexts);
    }

    public int getPort() {
        return this.connector.getLocalPort();
    }

    public void prepare(int port) throws IOException, URISyntaxException {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.connector.setPort(port);
        this.server.addConnector((Connector)this.connector);
        WebSocketHandler wsHandler = new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                LOG.debug("Configuring WebSocketServerFactory ...", new Object[0]);
                factory.getExtensionFactory().register("@frame-capture", FrameCaptureExtension.class);
                factory.setCreator((WebSocketCreator)BrowserDebugTool.this);
                factory.getPolicy().setIdleTimeout(30000L);
                factory.getPolicy().setMaxTextMessageSize(0xF00000);
            }
        };
        this.server.setHandler((Handler)wsHandler);
        Resource staticResourceBase = this.findStaticResources();
        ResourceHandler rHandler = new ResourceHandler();
        rHandler.setDirectoriesListed(true);
        rHandler.setBaseResource(staticResourceBase);
        wsHandler.setHandler((Handler)rHandler);
        LOG.info("{} setup on port {}", new Object[]{this.getClass().getName(), port});
    }

    private Resource findStaticResources() throws FileNotFoundException, URISyntaxException, MalformedURLException {
        Path path = MavenTestingUtils.getTestResourcePathDir((String)"browser-debug-tool");
        LOG.info("Static Resources: {}", new Object[]{path});
        return new PathResource(path);
    }

    public void start() throws Exception {
        this.server.start();
        LOG.info("Server available on port {}", new Object[]{this.getPort()});
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

