/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.browser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketSession;

@WebSocket
public class BrowserSocket {
    private static final Logger LOG = Log.getLogger(BrowserSocket.class);
    private Session session;
    private final String userAgent;
    private final String requestedExtensions;

    public BrowserSocket(String ua, String reqExts) {
        this.userAgent = ua;
        this.requestedExtensions = reqExts;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOG.info("Connect [{}]", new Object[]{session});
        this.session = session;
    }

    @OnWebSocketClose
    public void onDisconnect(int statusCode, String reason) {
        this.session = null;
        LOG.info("Closed [{}, {}]", new Object[]{statusCode, reason});
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        this.session = null;
        LOG.warn("Error", cause);
    }

    @OnWebSocketMessage
    public void onTextMessage(String message) {
        if (message.length() > 300) {
            int len = message.length();
            LOG.info("onTextMessage({} ... {}) size:{}", new Object[]{message.substring(0, 15), message.substring(len - 15, len).replaceAll("[\r\n]*", ""), len});
        } else {
            LOG.info("onTextMessage({})", new Object[]{message});
        }
        if (message.contains("\n")) {
            this.writeMessage(message);
            return;
        }
        if (message.charAt(0) == '@') {
            String name = message.substring(1);
            URL url = Loader.getResource((String)name);
            if (url == null) {
                this.writeMessage("Unable to find resource: " + name);
                return;
            }
            try (InputStream in = url.openStream();){
                String data = IO.toString((InputStream)in);
                this.writeMessage(data);
            }
            catch (IOException e) {
                this.writeMessage("Unable to read resource: " + name);
                LOG.warn("Unable to read resource: " + name, (Throwable)e);
            }
            return;
        }
        int idx = message.indexOf(58);
        if (idx > 0) {
            String key = message.substring(0, idx).toLowerCase(Locale.ENGLISH);
            String val = message.substring(idx + 1);
            switch (key) {
                case "info": {
                    if (StringUtil.isBlank((String)this.userAgent)) {
                        this.writeMessage("Client has no User-Agent");
                    } else {
                        this.writeMessage("Client User-Agent: " + this.userAgent);
                    }
                    if (StringUtil.isBlank((String)this.requestedExtensions)) {
                        this.writeMessage("Client requested no Sec-WebSocket-Extensions");
                        break;
                    }
                    this.writeMessage("Client requested Sec-WebSocket-Extensions: " + this.requestedExtensions);
                    this.writeMessage("Negotiated Sec-WebSocket-Extensions: " + this.session.getUpgradeResponse().getHeader("Sec-WebSocket-Extensions"));
                    break;
                }
                case "many": {
                    String[] parts = val.split(",");
                    int size = Integer.parseInt(parts[0]);
                    int count = Integer.parseInt(parts[1]);
                    this.writeManyAsync(size, count);
                    break;
                }
                case "manythreads": {
                    String[] parts = val.split(",");
                    int threadCount = Integer.parseInt(parts[0]);
                    int size = Integer.parseInt(parts[1]);
                    int count = Integer.parseInt(parts[2]);
                    Thread[] threads = new Thread[threadCount];
                    for (int n = 0; n < threadCount; ++n) {
                        threads[n] = new Thread((Runnable)new WriteMany(this.session.getRemote(), size, count), "WriteMany[" + n + "]");
                    }
                    for (Thread thread : threads) {
                        thread.start();
                    }
                    break;
                }
                case "time": {
                    Calendar now = Calendar.getInstance();
                    DateFormat sdf = SimpleDateFormat.getDateTimeInstance(0, 0);
                    this.writeMessage("Server time: %s", sdf.format(now.getTime()));
                    break;
                }
                case "dump": {
                    ((WebSocketSession)this.session).dumpStdErr();
                    break;
                }
                default: {
                    this.writeMessage("key[%s] val[%s]", key, val);
                }
            }
            return;
        }
        this.writeMessage(message);
    }

    private void writeManyAsync(int size, int count) {
        char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-|{}[]():".toCharArray();
        int lettersLen = letters.length;
        char[] randomText = new char[size];
        Random rand = new Random(42L);
        for (int n = 0; n < count; ++n) {
            for (int i = 0; i < size; ++i) {
                randomText[i] = letters[rand.nextInt(lettersLen)];
            }
            this.writeMessage("Many [%s]", String.valueOf(randomText));
        }
    }

    private void writeMessage(String message) {
        if (this.session == null) {
            LOG.debug("Not connected", new Object[0]);
            return;
        }
        if (!this.session.isOpen()) {
            LOG.debug("Not open", new Object[0]);
            return;
        }
        this.session.getRemote().sendString(message, null);
    }

    private void writeMessage(String format, Object ... args) {
        this.writeMessage(String.format(format, args));
    }

    private static class WriteMany
    implements Runnable {
        private RemoteEndpoint remote;
        private int size;
        private int count;

        public WriteMany(RemoteEndpoint remote, int size, int count) {
            this.remote = remote;
            this.size = size;
            this.count = count;
        }

        @Override
        public void run() {
            char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-|{}[]():".toCharArray();
            int lettersLen = letters.length;
            char[] randomText = new char[this.size];
            Random rand = new Random(42L);
            for (int n = 0; n < this.count; ++n) {
                for (int i = 0; i < this.size; ++i) {
                    randomText[i] = letters[rand.nextInt(lettersLen)];
                }
                String msg = String.format("ManyThreads [%s]", String.valueOf(randomText));
                this.remote.sendString(msg, null);
            }
        }
    }
}

