/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples;

import java.io.IOException;
import org.eclipse.jetty.websocket.server.examples.MyEchoSocket;
import org.eclipse.jetty.websocket.server.examples.echo.BigEchoSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class MyCustomCreationServlet
extends WebSocketServlet {
    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new MyCustomCreator());
    }

    public static class MyCustomCreator
    implements WebSocketCreator {
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            String query = req.getQueryString();
            if (query == null || query.length() <= 0) {
                try {
                    resp.sendForbidden("Unspecified query");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
            if (query.contains("bigecho")) {
                return new BigEchoSocket();
            }
            if (query.contains("echo")) {
                return new MyEchoSocket();
            }
            return null;
        }
    }
}

