/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples.echo;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket(maxTextMessageSize=65536, maxBinaryMessageSize=65536)
public class BigEchoSocket {
    private static final Logger LOG = Log.getLogger(BigEchoSocket.class);

    @OnWebSocketMessage
    public void onBinary(Session session, byte[] buf, int offset, int length) throws IOException {
        if (!session.isOpen()) {
            LOG.warn("Session is closed", new Object[0]);
            return;
        }
        RemoteEndpoint remote = session.getRemote();
        remote.sendBytes(ByteBuffer.wrap(buf, offset, length), null);
        if (remote.getBatchMode() == BatchMode.ON) {
            remote.flush();
        }
    }

    @OnWebSocketMessage
    public void onText(Session session, String message) throws IOException {
        if (!session.isOpen()) {
            LOG.warn("Session is closed", new Object[0]);
            return;
        }
        RemoteEndpoint remote = session.getRemote();
        remote.sendString(message, null);
        if (remote.getBatchMode() == BatchMode.ON) {
            remote.flush();
        }
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onError()", cause);
        }
    }
}

