/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples.echo;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.server.examples.echo.EchoBroadcastSocket;

@WebSocket
public class EchoBroadcastPingSocket
extends EchoBroadcastSocket {
    private KeepAlive keepAlive;

    @Override
    public void onClose(int statusCode, String reason) {
        this.keepAlive.shutdown();
        super.onClose(statusCode, reason);
    }

    @Override
    public void onOpen(Session session) {
        if (this.keepAlive == null) {
            this.keepAlive = new KeepAlive(session);
        }
        this.keepAlive.start();
        super.onOpen(session);
    }

    private static class KeepAlive
    extends Thread {
        private CountDownLatch latch;
        private Session session;

        public KeepAlive(Session session) {
            this.session = session;
        }

        @Override
        public void run() {
            try {
                while (!this.latch.await(10L, TimeUnit.SECONDS)) {
                    System.err.println("Ping");
                    ByteBuffer data = ByteBuffer.allocate(3);
                    data.put(new byte[]{1, 2, 3});
                    data.flip();
                    this.session.getRemote().sendPing(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutdown() {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        @Override
        public synchronized void start() {
            this.latch = new CountDownLatch(1);
            super.start();
        }
    }
}

