/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples.echo;

import java.util.Iterator;
import org.eclipse.jetty.websocket.server.examples.echo.BigEchoSocket;
import org.eclipse.jetty.websocket.server.examples.echo.EchoBroadcastPingSocket;
import org.eclipse.jetty.websocket.server.examples.echo.EchoBroadcastSocket;
import org.eclipse.jetty.websocket.server.examples.echo.EchoFragmentSocket;
import org.eclipse.jetty.websocket.server.examples.echo.LogSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class EchoCreator
implements WebSocketCreator {
    private BigEchoSocket bigEchoSocket = new BigEchoSocket();
    private EchoFragmentSocket echoFragmentSocket = new EchoFragmentSocket();
    private LogSocket logSocket = new LogSocket();

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        Iterator iterator = req.getSubProtocols().iterator();
        if (iterator.hasNext()) {
            String protocol;
            switch (protocol = (String)iterator.next()) {
                case "org.ietf.websocket.test-echo": 
                case "echo": {
                    resp.setAcceptedSubProtocol(protocol);
                    return this.bigEchoSocket;
                }
                case "org.ietf.websocket.test-echo-broadcast": 
                case "echo-broadcast": {
                    resp.setAcceptedSubProtocol(protocol);
                    return new EchoBroadcastSocket();
                }
                case "echo-broadcast-ping": {
                    resp.setAcceptedSubProtocol(protocol);
                    return new EchoBroadcastPingSocket();
                }
                case "org.ietf.websocket.test-echo-assemble": 
                case "echo-assemble": {
                    resp.setAcceptedSubProtocol(protocol);
                    return this.bigEchoSocket;
                }
                case "org.ietf.websocket.test-echo-fragment": 
                case "echo-fragment": {
                    resp.setAcceptedSubProtocol(protocol);
                    return this.echoFragmentSocket;
                }
            }
            return this.logSocket;
        }
        return null;
    }
}

