/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples.echo;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;

@WebSocket
public class EchoFragmentSocket {
    @OnWebSocketFrame
    public void onFrame(Session session, Frame frame) {
        if (!frame.getType().isData()) {
            return;
        }
        ByteBuffer data = frame.getPayload();
        int half = data.remaining() / 2;
        ByteBuffer buf1 = data.slice();
        ByteBuffer buf2 = data.slice();
        buf1.limit(half);
        buf2.position(half);
        RemoteEndpoint remote = session.getRemote();
        try {
            switch (frame.getType()) {
                case BINARY: {
                    remote.sendBytes(buf1, null);
                    remote.sendBytes(buf2, null);
                    break;
                }
                case TEXT: {
                    remote.sendString(BufferUtil.toUTF8String((ByteBuffer)buf1), null);
                    remote.sendString(BufferUtil.toUTF8String((ByteBuffer)buf2), null);
                    break;
                }
                default: {
                    throw new IOException("Unexpected frame type: " + frame.getType());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

