/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples.echo;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.server.examples.echo.EchoCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class ExampleEchoServer {
    private static final Logger LOG = Log.getLogger(ExampleEchoServer.class);
    private Server server = new Server();
    private ServerConnector connector = new ServerConnector(this.server);
    private boolean _verbose;
    private WebSocketHandler wsHandler;
    private ResourceHandler rHandler;

    public static void main(String ... args) {
        try {
            int port = 8080;
            boolean verbose = false;
            String docroot = "src/test/webapp";
            for (int i = 0; i < args.length; ++i) {
                String a = args[i];
                if ("-p".equals(a) || "--port".equals(a)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-v".equals(a) || "--verbose".equals(a)) {
                    verbose = true;
                    continue;
                }
                if ("-d".equals(a) || "--docroot".equals(a)) {
                    docroot = args[++i];
                    continue;
                }
                if (!a.startsWith("-")) continue;
                ExampleEchoServer.usage();
            }
            ExampleEchoServer server = new ExampleEchoServer(port);
            server.setVerbose(verbose);
            server.setResourceBase(docroot);
            server.runForever();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void usage() {
        System.err.println("java -cp{CLASSPATH} " + ExampleEchoServer.class + " [ OPTIONS ]");
        System.err.println("  -p|--port PORT    (default 8080)");
        System.err.println("  -v|--verbose ");
        System.err.println("  -d|--docroot file (default 'src/test/webapp')");
        System.exit(1);
    }

    public ExampleEchoServer(int port) {
        this.connector.setPort(port);
        this.server.addConnector((Connector)this.connector);
        this.wsHandler = new EchoSocketHandler();
        this.server.setHandler((Handler)this.wsHandler);
        this.rHandler = new ResourceHandler();
        this.rHandler.setDirectoriesListed(true);
        this.rHandler.setResourceBase("src/test/webapp");
        this.wsHandler.setHandler((Handler)this.rHandler);
    }

    public String getResourceBase() {
        return this.rHandler.getResourceBase();
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void runForever() throws Exception {
        this.server.start();
        String host = this.connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = this.connector.getLocalPort();
        System.err.printf("Echo Server started on ws://%s:%d/%n", host, port);
        System.err.println(this.server.dump());
        this.server.join();
    }

    public void setResourceBase(String dir) {
        this.rHandler.setResourceBase(dir);
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public final class EchoSocketHandler
    extends WebSocketHandler {
        public void configure(WebSocketServletFactory factory) {
            factory.setCreator((WebSocketCreator)new EchoCreator());
        }
    }
}

