/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.examples.echo;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class LogSocket
implements WebSocketListener {
    private boolean verbose = false;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        if (this.verbose) {
            System.err.printf("onWebSocketBinary(byte[%d] payload, %d, %d)%n", payload.length, offset, len);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        if (this.verbose) {
            System.err.printf("onWebSocketClose(%d, %s)%n", statusCode, this.quote(reason));
        }
    }

    public void onWebSocketConnect(Session session) {
        if (this.verbose) {
            System.err.printf("onWebSocketConnect(%s)%n", session);
        }
    }

    public void onWebSocketError(Throwable cause) {
        if (this.verbose) {
            System.err.printf("onWebSocketError((%s) %s)%n", cause.getClass().getName(), cause.getMessage());
            cause.printStackTrace(System.err);
        }
    }

    public void onWebSocketText(String message) {
        if (this.verbose) {
            System.err.printf("onWebSocketText(%s)%n", this.quote(message));
        }
    }

    private String quote(String str) {
        if (str == null) {
            return "<null>";
        }
        return '\"' + str + '\"';
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

