/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.helper;

import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.common.util.Sha1Sum;

public class CaptureSocket
extends WebSocketAdapter {
    private final CountDownLatch latch = new CountDownLatch(1);
    public LinkedBlockingQueue<String> messages = new LinkedBlockingQueue();

    public boolean awaitConnected(long timeout) throws InterruptedException {
        return this.latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.getSession().close();
    }

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        this.latch.countDown();
    }

    public void onWebSocketText(String message) {
        this.messages.add(message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            this.messages.add("binary[sha1=" + Sha1Sum.calculate((byte[])payload, (int)offset, (int)len) + "]");
        }
        catch (NoSuchAlgorithmException e) {
            this.messages.add("ERROR: Unable to calculate Binary SHA1: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

