/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.helper;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class RFCSocket {
    private static Logger LOG = Log.getLogger(RFCSocket.class);
    private Session session;

    @OnWebSocketMessage
    public void onBinary(byte[] buf, int offset, int len) throws IOException {
        LOG.debug("onBinary(byte[{}],{},{})", new Object[]{buf.length, offset, len});
        ByteBuffer data = ByteBuffer.wrap(buf, offset, len);
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendBytes(data, null);
        if (remote.getBatchMode() == BatchMode.ON) {
            remote.flush();
        }
    }

    @OnWebSocketConnect
    public void onOpen(Session sess) {
        this.session = sess;
    }

    @OnWebSocketMessage
    public void onText(String message) throws IOException {
        LOG.debug("onText({})", new Object[]{message});
        if (message.equals("CRASH")) {
            throw new RuntimeException("Something bad happened");
        }
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(message, null);
        if (remote.getBatchMode() == BatchMode.ON) {
            remote.flush();
        }
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        LOG.warn(cause);
    }
}

