/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class SafariD00 {
    private URI uri;
    private SocketAddress endpoint;
    private Socket socket;
    private OutputStream out;
    private InputStream in;

    public SafariD00(URI uri) {
        this.uri = uri;
        this.endpoint = new InetSocketAddress(uri.getHost(), uri.getPort());
    }

    public Socket connect() throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.endpoint, 1000);
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
        return this.socket;
    }

    public void disconnect() throws IOException {
        this.socket.close();
    }

    public void issueHandshake() throws IOException {
        StringBuilder req = new StringBuilder();
        req.append("GET ").append(this.uri.getPath()).append(" HTTP/1.1\r\n");
        req.append("Upgrade: WebSocket\r\n");
        req.append("Connection: Upgrade\r\n");
        req.append("Host: ").append(this.uri.getHost()).append(":").append(this.uri.getPort()).append("\r\n");
        req.append("Origin: http://www.google.com/\r\n");
        req.append("Sec-WebSocket-Key1: 15{ft  :6@87  0 M 5 c901\r\n");
        req.append("Sec-WebSocket-Key2: 3? C;7~0 8   \" 3 2105 6  `_ {\r\n");
        req.append("\r\n");
        byte[] reqBytes = req.toString().getBytes(StandardCharsets.UTF_8);
        byte[] hixieBytes = TypeUtil.fromHexString((String)"e739617916c9daf3");
        byte[] buf = new byte[reqBytes.length + hixieBytes.length];
        System.arraycopy(reqBytes, 0, buf, 0, reqBytes.length);
        System.arraycopy(hixieBytes, 0, buf, reqBytes.length, hixieBytes.length);
        this.out.write(buf, 0, buf.length);
        this.out.flush();
        InputStreamReader reader = new InputStreamReader(this.in);
        BufferedReader br = new BufferedReader(reader);
        this.socket.setSoTimeout(5000);
        boolean foundEnd = false;
        while (!foundEnd) {
            String line = br.readLine();
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.notNullValue());
            if (line.length() != 0) continue;
            foundEnd = true;
        }
        byte[] hixieHandshakeExpected = TypeUtil.fromHexString((String)"c7438d956cf611a6af70603e6fa54809");
        byte[] hixieHandshake = new byte[hixieHandshakeExpected.length];
        int readLen = this.in.read(hixieHandshake, 0, hixieHandshake.length);
        MatcherAssert.assertThat((String)"Read hixie handshake bytes", (Object)readLen, (Matcher)Matchers.is((Object)hixieHandshake.length));
    }

    public void sendMessage(String ... msgs) throws IOException {
        int len = 0;
        for (String msg : msgs) {
            len += msg.length() + 2;
        }
        ByteBuffer buf = ByteBuffer.allocate(len);
        for (String msg : msgs) {
            buf.put((byte)0);
            buf.put(msg.getBytes(StandardCharsets.UTF_8));
            buf.put((byte)-1);
        }
        BufferUtil.writeTo((ByteBuffer)buf, (OutputStream)this.out);
        this.out.flush();
    }
}

