/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.helper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class SessionSocket {
    private static final Logger LOG = Log.getLogger(SessionSocket.class);
    private Session session;

    @OnWebSocketConnect
    public void onConnect(Session sess) {
        this.session = sess;
    }

    @OnWebSocketMessage
    public void onText(String message) {
        LOG.debug("onText({})", new Object[]{message});
        if (message == null) {
            return;
        }
        try {
            if (message.startsWith("getParameterMap")) {
                int idx;
                String key;
                Map parameterMap = this.session.getUpgradeRequest().getParameterMap();
                List values = (List)parameterMap.get(key = message.substring((idx = message.indexOf(124)) + 1));
                if (values == null) {
                    this.sendString("<null>");
                    return;
                }
                StringBuilder valueStr = new StringBuilder();
                valueStr.append('[');
                boolean delim = false;
                for (String value : values) {
                    if (delim) {
                        valueStr.append(", ");
                    }
                    valueStr.append(value);
                    delim = true;
                }
                valueStr.append(']');
                LOG.debug("valueStr = {}", new Object[]{valueStr});
                this.sendString(valueStr.toString());
                return;
            }
            if ("session.isSecure".equals(message)) {
                String issecure = String.format("session.isSecure=%b", this.session.isSecure());
                this.sendString(issecure);
                return;
            }
            if ("session.upgradeRequest.requestURI".equals(message)) {
                String response = String.format("session.upgradeRequest.requestURI=%s", this.session.getUpgradeRequest().getRequestURI().toASCIIString());
                this.sendString(response);
                return;
            }
            if ("harsh-disconnect".equals(message)) {
                this.session.disconnect();
                return;
            }
            this.sendString(message);
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onError()", cause);
        }
    }

    protected void sendString(String text) throws IOException {
        RemoteEndpoint remote = this.session.getRemote();
        remote.sendString(text, null);
        if (remote.getBatchMode() == BatchMode.ON) {
            remote.flush();
        }
    }
}

