/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.misbehaving;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class AnnotatedRuntimeOnConnectSocket {
    public LinkedList<Throwable> errors = new LinkedList();
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public int closeStatusCode;
    public String closeReason;

    @OnWebSocketConnect
    public void onWebSocketConnect(Session sess) {
        throw new RuntimeException("Intentional Exception from onWebSocketConnect");
    }

    @OnWebSocketClose
    public void onWebSocketClose(int statusCode, String reason) {
        this.closeLatch.countDown();
        this.closeStatusCode = statusCode;
        this.closeReason = reason;
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        this.errors.add(cause);
    }

    public void reset() {
        this.closeLatch = new CountDownLatch(1);
        this.closeStatusCode = -1;
        this.closeReason = null;
        this.errors.clear();
    }
}

