/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.misbehaving;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class ListenerRuntimeOnConnectSocket
extends WebSocketAdapter {
    public LinkedList<Throwable> errors = new LinkedList();
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public int closeStatusCode;
    public String closeReason;

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        throw new RuntimeException("Intentional Exception from onWebSocketConnect");
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.closeLatch.countDown();
        this.closeStatusCode = statusCode;
        this.closeReason = reason;
    }

    public void onWebSocketError(Throwable cause) {
        this.errors.add(cause);
    }

    public void onWebSocketText(String message) {
        this.getRemote().sendStringByFuture(message);
    }

    public void reset() {
        this.closeLatch = new CountDownLatch(1);
        this.closeStatusCode = -1;
        this.closeReason = null;
        this.errors.clear();
    }
}

