/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.misbehaving;

import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.misbehaving.AnnotatedRuntimeOnConnectSocket;
import org.eclipse.jetty.websocket.server.misbehaving.BadSocketsServlet;
import org.eclipse.jetty.websocket.server.misbehaving.ListenerRuntimeOnConnectSocket;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class MisbehavingClassTest {
    private static SimpleServletServer server;
    private static BadSocketsServlet badSocketsServlet;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        badSocketsServlet = new BadSocketsServlet();
        server = new SimpleServletServer((HttpServlet)badSocketsServlet);
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testListenerRuntimeOnConnect() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "listener-runtime-connect");
        request.idleTimeout(1L, TimeUnit.SECONDS);
        ListenerRuntimeOnConnectSocket socket = MisbehavingClassTest.badSocketsServlet.listenerRuntimeConnect;
        socket.reset();
        CompletableFuture connFut = request.sendAsync();
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{ListenerRuntimeOnConnectSocket.class, WebSocketSession.class});
             BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame frame = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"frames[0].opcode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
            CloseInfo close = new CloseInfo((Frame)frame);
            MatcherAssert.assertThat((String)"Close Status Code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1011));
            clientConn.write((WebSocketFrame)close.asFrame());
            MatcherAssert.assertThat((String)"Close Latch", (Object)socket.closeLatch.await(1L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)"closeStatusCode", (Object)socket.closeStatusCode, (Matcher)Matchers.is((Object)1011));
            MatcherAssert.assertThat((String)"socket.onErrors", (Object)socket.errors.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Throwable cause = socket.errors.pop();
            MatcherAssert.assertThat((String)"Error type", (Object)cause, (Matcher)Matchers.instanceOf(RuntimeException.class));
            cause = socket.errors.peek();
            if (cause != null) {
                MatcherAssert.assertThat((String)"Error type", (Object)cause, (Matcher)Matchers.instanceOf(ClosedChannelException.class));
            }
        }
    }

    @Test
    public void testAnnotatedRuntimeOnConnect() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "annotated-runtime-connect");
        request.idleTimeout(1L, TimeUnit.SECONDS);
        AnnotatedRuntimeOnConnectSocket socket = MisbehavingClassTest.badSocketsServlet.annotatedRuntimeConnect;
        socket.reset();
        CompletableFuture connFut = request.sendAsync();
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{AnnotatedRuntimeOnConnectSocket.class});
             BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame frame = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"frames[0].opcode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
            CloseInfo close = new CloseInfo((Frame)frame);
            MatcherAssert.assertThat((String)"Close Status Code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1011));
            clientConn.write((WebSocketFrame)close.asFrame());
            MatcherAssert.assertThat((String)"Close Latch", (Object)socket.closeLatch.await(1L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)"closeStatusCode", (Object)socket.closeStatusCode, (Matcher)Matchers.is((Object)1011));
            MatcherAssert.assertThat((String)"socket.onErrors", (Object)socket.errors.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            Throwable cause = socket.errors.pop();
            MatcherAssert.assertThat((String)"Error type", (Object)cause, (Matcher)Matchers.instanceOf(RuntimeException.class));
            cause = socket.errors.peek();
            if (cause != null) {
                MatcherAssert.assertThat((String)"Error type", (Object)cause, (Matcher)Matchers.instanceOf(ClosedChannelException.class));
            }
        }
    }
}

