/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ant.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;

public class GitInitTask
extends Task {
    private File destination;
    private boolean bare;

    public void setDest(File dest) {
        this.destination = dest;
    }

    public void setBare(boolean bare) {
        this.bare = bare;
    }

    public void execute() throws BuildException {
        if (this.bare) {
            this.log("Initializing bare repository at " + this.destination);
        } else {
            this.log("Initializing repository at " + this.destination);
        }
        try {
            InitCommand init = Git.init();
            init.setBare(this.bare).setDirectory(this.destination);
            init.call();
        }
        catch (JGitInternalException e) {
            throw new BuildException("Could not initialize repository", (Throwable)e);
        }
    }
}

