/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.glue;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.glue.NoParameterFilterConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class UrlPipeline {
    private final Filter[] filters;
    private final HttpServlet servlet;

    UrlPipeline(Filter[] filters, HttpServlet servlet) {
        this.filters = filters;
        this.servlet = servlet;
    }

    void init(ServletContext context, Set<Object> inited) throws ServletException {
        for (Filter ref : this.filters) {
            UrlPipeline.initFilter(ref, context, inited);
        }
        UrlPipeline.initServlet(this.servlet, context, inited);
    }

    private static void initFilter(Filter ref, ServletContext context, Set<Object> inited) throws ServletException {
        if (!inited.contains(ref)) {
            ref.init((FilterConfig)new NoParameterFilterConfig(ref.getClass().getName(), context));
            inited.add(ref);
        }
    }

    private static void initServlet(final HttpServlet ref, final ServletContext context, Set<Object> inited) throws ServletException {
        if (!inited.contains(ref)) {
            ref.init(new ServletConfig(){

                public String getInitParameter(String name) {
                    return null;
                }

                public Enumeration getInitParameterNames() {
                    return new Enumeration<String>(){

                        @Override
                        public boolean hasMoreElements() {
                            return false;
                        }

                        @Override
                        public String nextElement() {
                            throw new NoSuchElementException();
                        }
                    };
                }

                public ServletContext getServletContext() {
                    return context;
                }

                public String getServletName() {
                    return ref.getClass().getName();
                }
            });
            inited.add(ref);
        }
    }

    void destroy(Set<Object> destroyed) {
        for (Filter ref : this.filters) {
            UrlPipeline.destroyFilter(ref, destroyed);
        }
        UrlPipeline.destroyServlet(this.servlet, destroyed);
    }

    private static void destroyFilter(Filter ref, Set<Object> destroyed) {
        if (!destroyed.contains(ref)) {
            ref.destroy();
            destroyed.add(ref);
        }
    }

    private static void destroyServlet(HttpServlet ref, Set<Object> destroyed) {
        if (!destroyed.contains(ref)) {
            ref.destroy();
            destroyed.add(ref);
        }
    }

    abstract boolean match(HttpServletRequest var1);

    void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        if (0 < this.filters.length) {
            new Chain(this.filters, this.servlet).doFilter((ServletRequest)req, (ServletResponse)rsp);
        } else {
            this.servlet.service((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    private static class Chain
    implements FilterChain {
        private final Filter[] filters;
        private final HttpServlet servlet;
        private int filterIdx;

        Chain(Filter[] filters, HttpServlet servlet) {
            this.filters = filters;
            this.servlet = servlet;
        }

        public void doFilter(ServletRequest req, ServletResponse rsp) throws IOException, ServletException {
            if (this.filterIdx < this.filters.length) {
                this.filters[this.filterIdx++].doFilter(req, rsp, (FilterChain)this);
            } else {
                this.servlet.service(req, rsp);
            }
        }
    }
}

