/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.FileSender;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.lib.Repository;

abstract class ObjectFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final String contentType;

    ObjectFileServlet(String contentType) {
        this.contentType = contentType;
    }

    abstract String etag(FileSender var1) throws IOException;

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        this.serve(req, rsp, true);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        this.serve(req, rsp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serve(HttpServletRequest req, HttpServletResponse rsp, boolean sendBody) throws IOException {
        FileSender sender;
        File obj = new File(ObjectFileServlet.objects(req), req.getPathInfo());
        try {
            sender = new FileSender(obj);
        }
        catch (FileNotFoundException e) {
            rsp.sendError(404);
            return;
        }
        try {
            String etag = this.etag(sender);
            long lastModified = sender.getLastModified() / 1000L * 1000L;
            String ifNoneMatch = req.getHeader("If-None-Match");
            if (etag != null && etag.equals(ifNoneMatch)) {
                rsp.sendError(304);
                return;
            }
            long ifModifiedSince = req.getDateHeader("If-Modified-Since");
            if (0L < lastModified && lastModified < ifModifiedSince) {
                rsp.sendError(304);
                return;
            }
            if (etag != null) {
                rsp.setHeader("ETag", etag);
            }
            if (0L < lastModified) {
                rsp.setDateHeader("Last-Modified", lastModified);
            }
            rsp.setContentType(this.contentType);
            sender.serve(req, rsp, sendBody);
        }
        finally {
            sender.close();
        }
    }

    private static File objects(HttpServletRequest req) {
        Repository db = ServletUtils.getRepository((ServletRequest)req);
        return ((ObjectDirectory)db.getObjectDatabase()).getDirectory();
    }

    static class PackIdx
    extends PackData {
        private static final long serialVersionUID = 1L;

        PackIdx() {
            super("application/x-git-packed-objects-toc");
        }
    }

    static class Pack
    extends PackData {
        private static final long serialVersionUID = 1L;

        Pack() {
            super("application/x-git-packed-objects");
        }
    }

    private static abstract class PackData
    extends ObjectFileServlet {
        private static final long serialVersionUID = 1L;

        PackData(String contentType) {
            super(contentType);
        }

        String etag(FileSender sender) throws IOException {
            return sender.getTailChecksum();
        }
    }

    static class Loose
    extends ObjectFileServlet {
        private static final long serialVersionUID = 1L;

        Loose() {
            super("application/x-git-loose-object");
        }

        String etag(FileSender sender) throws IOException {
            return Long.toHexString(sender.getLastModified());
        }
    }
}

