/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.ClientVersionUtil;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.SmartOutputStream;
import org.eclipse.jgit.http.server.SmartServiceInfoRefs;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.InternalHttpServerGlue;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

class UploadPackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    UploadPackServlet() {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (!"application/x-git-upload-pack-request".equals(req.getContentType())) {
            rsp.sendError(415);
            return;
        }
        int[] version = ClientVersionUtil.parseVersion(req.getHeader("User-Agent"));
        if (ClientVersionUtil.hasChunkedEncodingRequestBug(version, req)) {
            GitSmartHttpTools.sendError(req, rsp, 400, "\n\n" + HttpServerText.get().clientHas175ChunkedEncodingBug);
            return;
        }
        SmartOutputStream out = new SmartOutputStream(req, rsp, false){

            public void flush() throws IOException {
                this.doFlush();
            }
        };
        UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
        try {
            up.setBiDirectionalPipe(false);
            rsp.setContentType("application/x-git-upload-pack-result");
            up.upload(ServletUtils.getInputStream(req), (OutputStream)((Object)out), null);
            out.close();
        }
        catch (ServiceMayNotContinueException e) {
            if (e.isOutput()) {
                ServletUtils.consumeRequestBody(req);
                out.close();
            } else if (!rsp.isCommitted()) {
                rsp.reset();
                GitSmartHttpTools.sendError(req, rsp, 403, e.getMessage());
            }
            return;
        }
        catch (UploadPackInternalServerErrorException e) {
            this.getServletContext().log(HttpServerText.get().internalErrorDuringUploadPack, e.getCause());
            ServletUtils.consumeRequestBody(req);
            out.close();
        }
        catch (Throwable e) {
            this.getServletContext().log(HttpServerText.get().internalErrorDuringUploadPack, e);
            if (!rsp.isCommitted()) {
                rsp.reset();
                GitSmartHttpTools.sendError(req, rsp, 500);
            }
            return;
        }
    }

    static class Factory
    implements Filter {
        private final UploadPackFactory<HttpServletRequest> uploadPackFactory;

        Factory(UploadPackFactory<HttpServletRequest> uploadPackFactory) {
            this.uploadPackFactory = uploadPackFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            UploadPack rp;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            try {
                rp = this.uploadPackFactory.create((Object)req, ServletUtils.getRepository((ServletRequest)req));
            }
            catch (ServiceNotAuthorizedException e) {
                rsp.sendError(401);
                return;
            }
            catch (ServiceNotEnabledException e) {
                GitSmartHttpTools.sendError(req, rsp, 403);
                return;
            }
            try {
                req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)rp);
                chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
            }
            finally {
                req.removeAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }

    static class InfoRefs
    extends SmartServiceInfoRefs {
        private final UploadPackFactory<HttpServletRequest> uploadPackFactory;

        InfoRefs(UploadPackFactory<HttpServletRequest> uploadPackFactory, List<Filter> filters) {
            super("git-upload-pack", filters);
            this.uploadPackFactory = uploadPackFactory;
        }

        @Override
        protected void begin(HttpServletRequest req, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            UploadPack up = this.uploadPackFactory.create((Object)req, db);
            InternalHttpServerGlue.setPeerUserAgent((UploadPack)up, (String)req.getHeader("User-Agent"));
            req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)up);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void advertise(HttpServletRequest req, RefAdvertiser.PacketLineOutRefAdvertiser pck) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            try {
                up.setBiDirectionalPipe(false);
                up.sendAdvertisedRefs((RefAdvertiser)pck);
            }
            finally {
                up.getRevWalk().release();
            }
        }
    }
}

