/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.http.server.ClientVersionUtil;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.SmartOutputStream;
import org.eclipse.jgit.http.server.SmartServiceInfoRefs;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.InternalHttpServerGlue;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

class ReceivePackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    ReceivePackServlet() {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (!"application/x-git-receive-pack-request".equals(req.getContentType())) {
            rsp.sendError(415);
            return;
        }
        int[] version = ClientVersionUtil.parseVersion(req.getHeader("User-Agent"));
        if (ClientVersionUtil.hasChunkedEncodingRequestBug(version, req)) {
            GitSmartHttpTools.sendError(req, rsp, 400, "\n\n" + HttpServerText.get().clientHas175ChunkedEncodingBug);
            return;
        }
        SmartOutputStream out = new SmartOutputStream(req, rsp, false){

            public void flush() throws IOException {
                this.doFlush();
            }
        };
        ReceivePack rp = (ReceivePack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
        try {
            rp.setBiDirectionalPipe(false);
            rp.setEchoCommandFailures(ClientVersionUtil.hasPushStatusBug(version));
            rsp.setContentType("application/x-git-receive-pack-result");
            rp.receive(ServletUtils.getInputStream(req), (OutputStream)((Object)out), null);
            out.close();
        }
        catch (CorruptObjectException e) {
            this.getServletContext().log(MessageFormat.format(HttpServerText.get().receivedCorruptObject, e.getMessage(), ServletUtils.identify(rp.getRepository())));
            ServletUtils.consumeRequestBody(req);
            out.close();
        }
        catch (UnpackException e) {
            this.log(rp.getRepository(), e.getCause());
            ServletUtils.consumeRequestBody(req);
            out.close();
        }
        catch (Throwable e) {
            this.log(rp.getRepository(), e);
            if (!rsp.isCommitted()) {
                rsp.reset();
                GitSmartHttpTools.sendError(req, rsp, 500);
            }
            return;
        }
    }

    private void log(Repository git, Throwable e) {
        this.getServletContext().log(MessageFormat.format(HttpServerText.get().internalErrorDuringReceivePack, ServletUtils.identify(git)), e);
    }

    static class Factory
    implements Filter {
        private final ReceivePackFactory<HttpServletRequest> receivePackFactory;

        Factory(ReceivePackFactory<HttpServletRequest> receivePackFactory) {
            this.receivePackFactory = receivePackFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ReceivePack rp;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            try {
                rp = this.receivePackFactory.create((Object)req, ServletUtils.getRepository((ServletRequest)req));
            }
            catch (ServiceNotAuthorizedException e) {
                rsp.sendError(401);
                return;
            }
            catch (ServiceNotEnabledException e) {
                GitSmartHttpTools.sendError(req, rsp, 403);
                return;
            }
            try {
                req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)rp);
                chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
            }
            finally {
                req.removeAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }

    static class InfoRefs
    extends SmartServiceInfoRefs {
        private final ReceivePackFactory<HttpServletRequest> receivePackFactory;

        InfoRefs(ReceivePackFactory<HttpServletRequest> receivePackFactory, List<Filter> filters) {
            super("git-receive-pack", filters);
            this.receivePackFactory = receivePackFactory;
        }

        @Override
        protected void begin(HttpServletRequest req, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            ReceivePack rp = this.receivePackFactory.create((Object)req, db);
            InternalHttpServerGlue.setPeerUserAgent((ReceivePack)rp, (String)req.getHeader("User-Agent"));
            req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)rp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void advertise(HttpServletRequest req, RefAdvertiser.PacketLineOutRefAdvertiser pck) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            ReceivePack rp = (ReceivePack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            try {
                rp.sendAdvertisedRefs((RefAdvertiser)pck);
            }
            finally {
                rp.getRevWalk().close();
            }
        }
    }
}

