/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.glue;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.glue.RegexPipeline;
import org.eclipse.jgit.http.server.glue.ServletBinder;
import org.eclipse.jgit.http.server.glue.ServletBinderImpl;
import org.eclipse.jgit.http.server.glue.SuffixPipeline;
import org.eclipse.jgit.http.server.glue.UrlPipeline;

public class MetaFilter
implements Filter {
    static final String REGEX_GROUPS = "org.eclipse.jgit.http.server.glue.MetaServlet.serveRegex";
    private ServletContext servletContext;
    private final List<ServletBinderImpl> bindings = new ArrayList<ServletBinderImpl>();
    private volatile UrlPipeline[] pipelines;

    public ServletBinder serve(String path) {
        if (path.startsWith("*")) {
            return this.register(new SuffixPipeline.Binder(path.substring(1)));
        }
        throw new IllegalArgumentException(MessageFormat.format(HttpServerText.get().pathNotSupported, path));
    }

    public ServletBinder serveRegex(String expression) {
        return this.register(new RegexPipeline.Binder(expression));
    }

    public ServletBinder serveRegex(Pattern pattern) {
        return this.register(new RegexPipeline.Binder(pattern));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void destroy() {
        if (this.pipelines != null) {
            Set<Object> destroyed = MetaFilter.newIdentitySet();
            for (UrlPipeline p : this.pipelines) {
                p.destroy(destroyed);
            }
            this.pipelines = null;
        }
    }

    private static Set<Object> newIdentitySet() {
        final IdentityHashMap m = new IdentityHashMap();
        return new AbstractSet<Object>(){

            @Override
            public boolean add(Object o) {
                return m.put(o, o) == null;
            }

            @Override
            public boolean contains(Object o) {
                return m.keySet().contains(o);
            }

            @Override
            public Iterator<Object> iterator() {
                return m.keySet().iterator();
            }

            @Override
            public int size() {
                return m.size();
            }
        };
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        UrlPipeline p = this.find(req);
        if (p != null) {
            p.service(req, res);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private UrlPipeline find(HttpServletRequest req) throws ServletException {
        for (UrlPipeline p : this.getPipelines()) {
            if (!p.match(req)) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletBinder register(ServletBinderImpl b) {
        List<ServletBinderImpl> list = this.bindings;
        synchronized (list) {
            if (this.pipelines != null) {
                throw new IllegalStateException(HttpServerText.get().servletAlreadyInitialized);
            }
            this.bindings.add(b);
        }
        return this.register((ServletBinder)b);
    }

    protected ServletBinder register(ServletBinder b) {
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UrlPipeline[] getPipelines() throws ServletException {
        UrlPipeline[] r = this.pipelines;
        if (r == null) {
            List<ServletBinderImpl> list = this.bindings;
            synchronized (list) {
                r = this.pipelines;
                if (r == null) {
                    r = this.createPipelines();
                    this.pipelines = r;
                }
            }
        }
        return r;
    }

    private UrlPipeline[] createPipelines() throws ServletException {
        UrlPipeline[] array = new UrlPipeline[this.bindings.size()];
        for (int i = 0; i < this.bindings.size(); ++i) {
            array[i] = this.bindings.get(i).create();
        }
        Set<Object> inited = MetaFilter.newIdentitySet();
        for (UrlPipeline p : array) {
            p.init(this.servletContext, inited);
        }
        return array;
    }
}

