/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.iplog.CQ;
import org.eclipse.jgit.iplog.IPZillaQuery;
import org.eclipse.jgit.iplog.IpLogText;
import org.eclipse.jgit.iplog.Project;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.LockFile;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IpLogMeta {
    public static final String IPLOG_CONFIG_FILE = ".eclipse_iplog";
    private static final String S_PROJECT = "project";
    private static final String S_CQ = "CQ";
    private static final String S_CONSUMES = "consumes";
    private static final String S_REVIEW = "review";
    private static final String K_URL = "url";
    private static final String K_NAME = "name";
    private static final String K_VERSION = "version";
    private static final String K_COMMENTS = "comments";
    private static final String K_SKIP_COMMIT = "skipCommit";
    private static final String K_LICENSE = "license";
    private static final String K_DESCRIPTION = "description";
    private static final String K_USE = "use";
    private static final String K_STATE = "state";
    private List<Project> projects = new ArrayList<Project>();
    private List<Project> consumedProjects = new ArrayList<Project>();
    private Set<CQ> cqs = new HashSet<CQ>();
    private String reviewUrl;

    List<Project> getProjects() {
        return this.projects;
    }

    List<Project> getConsumedProjects() {
        return this.consumedProjects;
    }

    Set<CQ> getCQs() {
        return this.cqs;
    }

    String getReviewUrl() {
        return this.reviewUrl;
    }

    void loadFrom(Config cfg) {
        this.projects.clear();
        this.consumedProjects.clear();
        this.cqs.clear();
        this.projects.addAll(this.parseProjects(cfg, S_PROJECT));
        this.consumedProjects.addAll(this.parseProjects(cfg, S_CONSUMES));
        for (String id : cfg.getSubsections(S_CQ)) {
            CQ cq = new CQ(Long.parseLong(id));
            cq.setDescription(cfg.getString(S_CQ, id, K_DESCRIPTION));
            cq.setLicense(cfg.getString(S_CQ, id, K_LICENSE));
            cq.setUse(cfg.getString(S_CQ, id, K_USE));
            cq.setState(cfg.getString(S_CQ, id, K_STATE));
            cq.setComments(cfg.getString(S_CQ, id, K_COMMENTS));
            this.cqs.add(cq);
        }
        this.reviewUrl = cfg.getString(S_REVIEW, null, K_URL);
    }

    private List<Project> parseProjects(Config cfg, String sectionName) {
        ArrayList<Project> dst = new ArrayList<Project>();
        for (String id : cfg.getSubsections(sectionName)) {
            String name = cfg.getString(sectionName, id, K_NAME);
            Project project = new Project(id, name);
            project.setVersion(cfg.getString(sectionName, id, K_VERSION));
            project.setComments(cfg.getString(sectionName, id, K_COMMENTS));
            for (String c : cfg.getStringList(sectionName, id, K_SKIP_COMMIT)) {
                project.addSkipCommit((AnyObjectId)ObjectId.fromString((String)c));
            }
            for (String license : cfg.getStringList(sectionName, id, K_LICENSE)) {
                project.addLicense(license);
            }
            dst.add(project);
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCQs(File file, FS fs, URL base, String username, String password) throws IOException, ConfigInvalidException {
        FileUtils.mkdirs((File)file.getParentFile(), (boolean)true);
        LockFile lf = new LockFile(file, fs);
        if (!lf.lock()) {
            throw new IOException(MessageFormat.format(IpLogText.get().cannotLock, file));
        }
        try {
            FileBasedConfig cfg = new FileBasedConfig(file, fs);
            cfg.load();
            this.loadFrom((Config)cfg);
            IPZillaQuery ipzilla = new IPZillaQuery(base, username, password);
            Set<CQ> current = ipzilla.getCQs(this.projects);
            for (CQ cq : IpLogMeta.sort(current, CQ.COMPARATOR)) {
                String id = Long.toString(cq.getID());
                IpLogMeta.set((Config)cfg, S_CQ, id, K_DESCRIPTION, cq.getDescription());
                IpLogMeta.set((Config)cfg, S_CQ, id, K_LICENSE, cq.getLicense());
                IpLogMeta.set((Config)cfg, S_CQ, id, K_USE, cq.getUse());
                IpLogMeta.set((Config)cfg, S_CQ, id, K_STATE, cq.getState());
                IpLogMeta.set((Config)cfg, S_CQ, id, K_COMMENTS, cq.getComments());
            }
            for (CQ cq : this.cqs) {
                if (current.contains(cq)) continue;
                cfg.unsetSection(S_CQ, Long.toString(cq.getID()));
            }
            lf.write(Constants.encode((String)cfg.toText()));
            if (!lf.commit()) {
                throw new IOException(MessageFormat.format(IpLogText.get().cannotWrite, file));
            }
        }
        finally {
            lf.unlock();
        }
    }

    private static void set(Config cfg, String section, String subsection, String key, String value) {
        if (value == null || "".equals(value)) {
            cfg.unset(section, subsection, key);
        } else {
            cfg.setString(section, subsection, key, value);
        }
    }

    private static <T, Q extends Comparator<T>> Iterable<T> sort(Collection<T> objs, Q cmp) {
        ArrayList<T> sorted = new ArrayList<T>(objs);
        Collections.sort(sorted, cmp);
        return sorted;
    }
}

