/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.iplog.IpLogText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Project {
    static final Comparator<Project> COMPARATOR = new Comparator<Project>(){

        @Override
        public int compare(Project a, Project b) {
            return a.getID().compareTo(b.getID());
        }
    };
    private final String id;
    private final String name;
    private String comments;
    private final Set<String> licenses = new TreeSet<String>();
    private final ObjectIdSubclassMap<ObjectId> skipCommits = new ObjectIdSubclassMap();
    private String version;

    Project(String id, String name) {
        this.id = id;
        this.name = name;
    }

    String getID() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getComments() {
        return this.comments;
    }

    void setComments(String comments) {
        this.comments = comments;
    }

    Set<String> getLicenses() {
        return Collections.unmodifiableSet(this.licenses);
    }

    void addLicense(String licenseName) {
        this.licenses.add(licenseName);
    }

    void addSkipCommit(AnyObjectId commit) {
        this.skipCommits.add(commit.copy());
    }

    boolean isSkippedCommit(AnyObjectId commit) {
        return this.skipCommits.contains(commit);
    }

    String getVersion() {
        return this.version;
    }

    void setVersion(String v) {
        this.version = v;
    }

    public String toString() {
        return MessageFormat.format(IpLogText.get().projectString, this.getID(), this.getName());
    }
}

