/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.iplog.CQ;
import org.eclipse.jgit.iplog.CSV;
import org.eclipse.jgit.iplog.IpLogText;
import org.eclipse.jgit.iplog.Project;
import org.eclipse.jgit.util.HttpSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IPZillaQuery {
    private static final String RE_EPL = "^.*(Eclipse Public License|EPL).*$";
    private final URL base;
    private final String username;
    private final String password;
    private final ProxySelector proxySelector = ProxySelector.getDefault();

    IPZillaQuery(URL base, String username, String password) {
        this.base = base;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<CQ> getCQs(Collection<Project> projects) throws IOException {
        try {
            this.login();
            HashSet<CQ> cqs = new HashSet<CQ>();
            for (Project project : projects) {
                cqs.addAll(this.queryOneProject(project));
            }
            HashSet<CQ> hashSet = cqs;
            return hashSet;
        }
        finally {
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CQ> queryOneProject(Project project) throws IOException {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        p.put("bugidtype", "include");
        p.put("chfieldto", "Now");
        p.put("component", project.getID());
        p.put("field-1-0-0", "component");
        p.put("type-1-0-0", "anyexact");
        p.put("value-1-0-0", project.getID());
        p.put("ctype", "csv");
        StringBuilder req = new StringBuilder();
        for (Map.Entry e : p.entrySet()) {
            if (req.length() > 0) {
                req.append('&');
            }
            req.append(URLEncoder.encode((String)e.getKey(), "UTF-8"));
            req.append('=');
            req.append(URLEncoder.encode((String)e.getValue(), "UTF-8"));
        }
        URL csv = new URL(new URL(this.base, "buglist.cgi").toString() + "?" + req);
        req = new StringBuilder();
        for (String name : new String[]{"bug_severity", "bug_status", "resolution", "short_desc", "cf_license", "keywords"}) {
            if (req.length() > 0) {
                req.append("%20");
            }
            req.append(name);
        }
        this.setCookie(csv, "COLUMNLIST", req.toString());
        HttpURLConnection conn = this.open(csv);
        if (HttpSupport.response((HttpURLConnection)conn) != 200) {
            throw new IOException(MessageFormat.format(IpLogText.get().queryFailed, csv, conn.getResponseCode() + " " + conn.getResponseMessage()));
        }
        BufferedReader br = this.reader(conn);
        try {
            Map<String, String> row;
            HashSet<CQ> cqs = new HashSet<CQ>();
            CSV in = new CSV(br);
            while ((row = in.next()) != null) {
                CQ cq = this.parseOneCQ(row);
                if (cq == null) continue;
                cqs.add(cq);
            }
            HashSet<CQ> hashSet = cqs;
            return hashSet;
        }
        finally {
            br.close();
        }
    }

    private BufferedReader reader(HttpURLConnection conn) throws UnsupportedEncodingException, IOException {
        String encoding = conn.getContentEncoding();
        InputStream in = conn.getInputStream();
        if (encoding != null && !encoding.equals("")) {
            return new BufferedReader(new InputStreamReader(in, encoding));
        }
        return new BufferedReader(new InputStreamReader(in));
    }

    private void login() throws MalformedURLException, UnsupportedEncodingException, ConnectException, IOException {
        URL login = new URL(this.base, "index.cgi");
        StringBuilder req = new StringBuilder();
        req.append("Bugzilla_login=");
        req.append(URLEncoder.encode(this.username, "UTF-8"));
        req.append('&');
        req.append("Bugzilla_password=");
        req.append(URLEncoder.encode(this.password, "UTF-8"));
        byte[] reqbin = req.toString().getBytes("UTF-8");
        HttpURLConnection c = this.open(login);
        c.setDoOutput(true);
        c.setFixedLengthStreamingMode(reqbin.length);
        c.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        OutputStream out = c.getOutputStream();
        out.write(reqbin);
        out.close();
        if (HttpSupport.response((HttpURLConnection)c) != 200) {
            throw new IOException(MessageFormat.format(IpLogText.get().loginFailed, this.username, login, c.getResponseCode() + " " + c.getResponseMessage()));
        }
        String content = this.readFully(c);
        Matcher matcher = Pattern.compile("<title>(.*)</title>", 2).matcher(content);
        if (!matcher.find()) {
            throw new IOException(MessageFormat.format(IpLogText.get().loginFailed, this.username, login, IpLogText.get().responseNotHTMLAsExpected));
        }
        String title = matcher.group(1);
        if (!"IPZilla Main Page".equals(title)) {
            throw new IOException(MessageFormat.format(IpLogText.get().loginFailed, this.username, login, MessageFormat.format(IpLogText.get().pageTitleWas, title)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFully(HttpURLConnection c) throws IOException {
        String enc = c.getContentEncoding();
        InputStreamReader reader = enc != null ? new InputStreamReader(c.getInputStream(), enc) : new InputStreamReader(c.getInputStream(), "ISO-8859-1");
        try {
            String line;
            StringBuilder b = new StringBuilder();
            BufferedReader r = new BufferedReader(reader);
            while ((line = r.readLine()) != null) {
                b.append(line).append('\n');
            }
            String string = b.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private void logout() throws MalformedURLException, ConnectException, IOException {
        HttpSupport.response((HttpURLConnection)this.open(new URL(this.base, "relogin.cgi")));
    }

    private HttpURLConnection open(URL url) throws ConnectException, IOException {
        Proxy proxy = HttpSupport.proxyFor((ProxySelector)this.proxySelector, (URL)url);
        HttpURLConnection c = (HttpURLConnection)url.openConnection(proxy);
        c.setUseCaches(false);
        return c;
    }

    private void setCookie(URL url, String name, String value) throws IOException {
        HashMap<String, List<String>> cols = new HashMap<String, List<String>>();
        cols.put("Set-Cookie", Collections.singletonList(name + "=" + value));
        try {
            CookieHandler.getDefault().put(url.toURI(), cols);
        }
        catch (URISyntaxException e) {
            IOException err = new IOException(MessageFormat.format(IpLogText.get().invalidURIFormat, url));
            err.initCause(e);
            throw err;
        }
    }

    private CQ parseOneCQ(Map<String, String> row) {
        long id = Long.parseLong(row.get("bug_id"));
        String state = row.get("bug_severity");
        String bug_status = row.get("bug_status");
        String resolution = row.get("resolution");
        String short_desc = row.get("short_desc");
        String license = row.get("cf_license");
        TreeSet<String> keywords = new TreeSet<String>();
        for (String w : row.get("keywords").split(", *")) {
            keywords.add(w);
        }
        if ("closed".equalsIgnoreCase(state) || "rejected".equalsIgnoreCase(state) || "withdrawn".equalsIgnoreCase(state)) {
            return null;
        }
        if (!keywords.contains("nonepl") && license.matches(RE_EPL)) {
            return null;
        }
        if (keywords.contains("epl")) {
            return null;
        }
        if (("new".equalsIgnoreCase(state) || "under_review".equalsIgnoreCase(state) || state.startsWith("awaiting_")) && ("RESOLVED".equalsIgnoreCase(bug_status) || "CLOSED".equalsIgnoreCase(bug_status))) {
            if ("FIXED".equalsIgnoreCase(resolution)) {
                state = "approved";
            } else {
                return null;
            }
        }
        StringBuilder use = new StringBuilder();
        for (String n : new String[]{"unmodified", "modified", "source", "binary"}) {
            if (!keywords.contains(n)) continue;
            if (use.length() > 0) {
                use.append(' ');
            }
            use.append(n);
        }
        if (keywords.contains("sourceandbinary")) {
            if (use.length() > 0) {
                use.append(' ');
            }
            use.append("source & binary");
        }
        CQ cq = new CQ(id);
        cq.setDescription(short_desc);
        cq.setLicense(license);
        cq.setState(state);
        if (use.length() > 0) {
            cq.setUse(use.toString().trim());
        }
        return cq;
    }
}

