/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.iplog;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCookieManager
extends CookieHandler {
    private Map<String, Map<String, String>> byHost = new HashMap<String, Map<String, String>>();

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        String host = this.hostOf(uri);
        Map<String, String> map = this.byHost.get(host);
        if (map == null || map.isEmpty()) {
            return requestHeaders;
        }
        HashMap<String, List<String>> r = new HashMap<String, List<String>>();
        r.putAll(requestHeaders);
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append(e.getKey());
            buf.append('=');
            buf.append(e.getValue());
        }
        r.put("Cookie", Collections.singletonList(buf.toString()));
        return Collections.unmodifiableMap(r);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        List<String> list = responseHeaders.get("Set-Cookie");
        if (list == null || list.isEmpty()) {
            return;
        }
        String host = this.hostOf(uri);
        Map<String, String> map = this.byHost.get(host);
        if (map == null) {
            map = new HashMap<String, String>();
            this.byHost.put(host, map);
        }
        for (String hdr : list) {
            String[] attributes = hdr.split(";");
            String nameValue = attributes[0].trim();
            int eq = nameValue.indexOf(61);
            String name = nameValue.substring(0, eq);
            String value = nameValue.substring(eq + 1);
            map.put(name, value);
        }
    }

    private String hostOf(URI uri) {
        StringBuilder key = new StringBuilder();
        key.append(uri.getScheme());
        key.append(':');
        key.append(uri.getHost());
        if (0 < uri.getPort()) {
            key.append(58 + uri.getPort());
        }
        return key.toString();
    }
}

