/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jgit.junit.http.AccessEvent;
import org.eclipse.jgit.junit.http.HttpTestCase;
import org.eclipse.jgit.junit.http.RecordingLogger;
import org.eclipse.jgit.junit.http.TestRequestLog;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;

public class AppServer {
    public static final String realm = "Secure Area";
    public static final String username = "agitter";
    public static final String password = "letmein";
    private final Server server = new Server();
    private final ServerConnector connector;
    private final ContextHandlerCollection contexts;
    private final TestRequestLog log;

    public AppServer() {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(8443);
        http_config.setOutputBufferSize(32768);
        this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        this.connector.setPort(0);
        try {
            InetAddress me = InetAddress.getByName("localhost");
            this.connector.setHost(me.getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot find localhost", e);
        }
        this.contexts = new ContextHandlerCollection();
        this.log = new TestRequestLog();
        this.log.setHandler((Handler)this.contexts);
        this.server.setConnectors(new Connector[]{this.connector});
        this.server.setHandler((Handler)this.log);
    }

    public ServletContextHandler addContext(String path) {
        this.assertNotYetSetUp();
        if ("".equals(path)) {
            path = "/";
        }
        ServletContextHandler ctx = new ServletContextHandler();
        ctx.setContextPath(path);
        this.contexts.addHandler((Handler)ctx);
        return ctx;
    }

    public ServletContextHandler authBasic(ServletContextHandler ctx) {
        this.assertNotYetSetUp();
        this.auth(ctx, (Authenticator)new BasicAuthenticator());
        return ctx;
    }

    private void auth(ServletContextHandler ctx, Authenticator authType) {
        String role = "can-access";
        MappedLoginService users = new MappedLoginService(){

            protected UserIdentity loadUser(String who) {
                return null;
            }

            protected void loadUsers() throws IOException {
                this.putUser(AppServer.username, (Credential)new Password(AppServer.password), new String[]{"can-access"});
            }
        };
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(new Constraint());
        cm.getConstraint().setAuthenticate(true);
        cm.getConstraint().setDataConstraint(0);
        cm.getConstraint().setRoles(new String[]{"can-access"});
        cm.setPathSpec("/*");
        ConstraintSecurityHandler sec = new ConstraintSecurityHandler();
        sec.setRealmName(realm);
        sec.setAuthenticator(authType);
        sec.setLoginService((LoginService)users);
        sec.setConstraintMappings(new ConstraintMapping[]{cm});
        sec.setHandler((Handler)ctx);
        this.contexts.removeHandler((Handler)ctx);
        this.contexts.addHandler((Handler)sec);
    }

    public void setUp() throws Exception {
        RecordingLogger.clear();
        this.log.clear();
        this.server.start();
    }

    public void tearDown() throws Exception {
        RecordingLogger.clear();
        this.log.clear();
        this.server.stop();
    }

    public URI getURI() {
        this.assertAlreadySetUp();
        String host = this.connector.getHost();
        if (host.contains(":") && !host.startsWith("[")) {
            host = "[" + host + "]";
        }
        String uri = "http://" + host + ":" + this.getPort();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected URI error on " + uri, e);
        }
    }

    public int getPort() {
        this.assertAlreadySetUp();
        return this.connector.getLocalPort();
    }

    public List<AccessEvent> getRequests() {
        return new ArrayList<AccessEvent>(this.log.getEvents());
    }

    public List<AccessEvent> getRequests(URIish base, String path) {
        return this.getRequests(HttpTestCase.join(base, path));
    }

    public List<AccessEvent> getRequests(String path) {
        ArrayList<AccessEvent> r = new ArrayList<AccessEvent>();
        for (AccessEvent event : this.log.getEvents()) {
            if (!event.getPath().equals(path)) continue;
            r.add(event);
        }
        return r;
    }

    private void assertNotYetSetUp() {
        Assert.assertFalse((String)"server is not running", (boolean)this.server.isRunning());
    }

    private void assertAlreadySetUp() {
        Assert.assertTrue((String)"server is running", (boolean)this.server.isRunning());
    }

    static {
        String prop = "org.eclipse.jetty.util.log.class";
        System.setProperty("org.eclipse.jetty.util.log.class", RecordingLogger.class.getName());
    }
}

