/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitServlet;
import org.eclipse.jgit.junit.http.AppServer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

public class SimpleHttpServer {
    AppServer server;
    private final Repository db;
    private URIish uri;

    public SimpleHttpServer(Repository repository) {
        this.db = repository;
        this.server = new AppServer();
    }

    public void start() throws Exception {
        ServletContextHandler sBasic = this.server.authBasic(this.smart("/sbasic"));
        this.server.setUp();
        String srcName = this.db.getDirectory().getName();
        this.uri = this.toURIish(sBasic, srcName);
    }

    public void stop() throws Exception {
        this.server.tearDown();
    }

    public URIish getUri() {
        return this.uri;
    }

    private ServletContextHandler smart(String path) {
        GitServlet gs = new GitServlet();
        gs.setRepositoryResolver((RepositoryResolver)new RepositoryResolver<HttpServletRequest>(){

            public Repository open(HttpServletRequest req, String name) throws RepositoryNotFoundException, ServiceNotEnabledException {
                if (!name.equals(SimpleHttpServer.nameOf(SimpleHttpServer.this.db))) {
                    throw new RepositoryNotFoundException(name);
                }
                SimpleHttpServer.this.db.incrementOpen();
                return SimpleHttpServer.this.db;
            }
        });
        ServletContextHandler ctx = this.server.addContext(path);
        ctx.addServlet(new ServletHolder((Servlet)gs), "/*");
        return ctx;
    }

    private static String nameOf(Repository db) {
        return db.getDirectory().getName();
    }

    private URIish toURIish(String path) throws URISyntaxException {
        URI u = this.server.getURI().resolve(path);
        return new URIish(u.toString());
    }

    private URIish toURIish(ServletContextHandler app, String name) throws URISyntaxException {
        String p = app.getContextPath();
        if (!p.endsWith("/") && !name.startsWith("/")) {
            p = p + "/";
        }
        p = p + name;
        return this.toURIish(p);
    }
}

