/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jgit.junit.http.AccessEvent;

class TestRequestLog
extends HandlerWrapper {
    private static final int MAX = 16;
    private final List<AccessEvent> events = new ArrayList<AccessEvent>();
    private final Semaphore active = new Semaphore(16);

    TestRequestLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        try {
            while (true) {
                try {
                    this.active.acquire(16);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            List<AccessEvent> list = this.events;
            synchronized (list) {
                this.events.clear();
            }
        }
        finally {
            this.active.release(16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AccessEvent> getEvents() {
        try {
            while (true) {
                try {
                    this.active.acquire(16);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            List<AccessEvent> list = this.events;
            synchronized (list) {
                List<AccessEvent> list2 = this.events;
                return list2;
            }
        }
        finally {
            this.active.release(16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            while (true) {
                try {
                    this.active.acquire();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            super.handle(target, baseRequest, request, response);
            if (DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
                this.log((Request)request, (Response)response);
            }
        }
        finally {
            this.active.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Request request, Response response) {
        List<AccessEvent> list = this.events;
        synchronized (list) {
            this.events.add(new AccessEvent(request, response));
        }
    }
}

