/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitServlet;
import org.eclipse.jgit.junit.http.AppServer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;

public class SimpleHttpServer {
    AppServer server;
    private final Repository db;
    private URIish uri;
    private URIish secureUri;

    public SimpleHttpServer(Repository repository) {
        this(repository, false);
    }

    public SimpleHttpServer(Repository repository, boolean withSsl) {
        this.db = repository;
        this.server = new AppServer(0, withSsl ? 0 : -1);
    }

    public void start() throws Exception {
        ServletContextHandler sBasic = this.server.authBasic(this.smart("/sbasic"), new String[0]);
        this.server.setUp();
        String srcName = this.db.getDirectory().getName();
        this.uri = this.toURIish(sBasic, srcName);
        int sslPort = this.server.getSecurePort();
        if (sslPort > 0) {
            this.secureUri = this.uri.setPort(sslPort).setScheme("https");
        }
    }

    public void stop() throws Exception {
        this.server.tearDown();
    }

    public URIish getUri() {
        return this.uri;
    }

    public URIish getSecureUri() {
        return this.secureUri;
    }

    private ServletContextHandler smart(String path) {
        GitServlet gs = new GitServlet();
        gs.setRepositoryResolver((req, name) -> {
            if (!name.equals(SimpleHttpServer.nameOf(this.db))) {
                throw new RepositoryNotFoundException(name);
            }
            this.db.incrementOpen();
            return this.db;
        });
        ServletContextHandler ctx = this.server.addContext(path);
        ctx.addServlet(new ServletHolder((Servlet)gs), "/*");
        return ctx;
    }

    private static String nameOf(Repository db) {
        return db.getDirectory().getName();
    }

    private URIish toURIish(String path) throws URISyntaxException {
        URI u = this.server.getURI().resolve(path);
        return new URIish(u.toString());
    }

    private URIish toURIish(ServletContextHandler app, String name) throws URISyntaxException {
        Object p = app.getContextPath();
        if (!((String)p).endsWith("/") && !name.startsWith("/")) {
            p = (String)p + "/";
        }
        p = (String)p + name;
        return this.toURIish((String)p);
    }
}

