/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.ssh;

import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.junit.ssh.SshTestHarness;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.junit.Test;

public abstract class SshBasicTestBase
extends SshTestHarness {
    protected File defaultCloneDir;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.defaultCloneDir = new File(this.getTemporaryDirectory(), "cloned");
    }

    @Test
    public void testSshCloneWithConfig() throws Exception {
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSshFetchWithConfig() throws Exception {
        Git git;
        File localClone = this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            git = new Git((Repository)this.db);
            try {
                this.writeTrashFile("SomeOtherFile.txt", "Other commit");
                git.add().addFilepattern("SomeOtherFile.txt").call();
                git.commit().setMessage("New commit").call();
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            git = Git.open((File)localClone);
            try {
                File f = new File(git.getRepository().getWorkTree(), "SomeOtherFile.txt");
                Assert.assertFalse((boolean)f.exists());
                git.pull().setRemote("origin").call();
                Assert.assertTrue((boolean)f.exists());
                Assert.assertEquals((Object)"Other commit", (Object)this.read(f));
            }
            finally {
                if (git != null) {
                    git.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

