/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.ssh;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.junit.ssh.SshBasicTestBase;
import org.eclipse.jgit.junit.ssh.SshTestHarness;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SshSupport;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theory;

public abstract class SshTestBase
extends SshBasicTestBase {
    @DataPoints
    public static String[] KEY_RESOURCES = new String[]{"id_dsa", "id_rsa_1024", "id_rsa_2048", "id_rsa_3072", "id_rsa_4096", "id_ecdsa_256", "id_ecdsa_384", "id_ecdsa_521", "id_ed25519", "id_dsa_testpass", "id_rsa_1024_testpass", "id_rsa_2048_testpass", "id_rsa_3072_testpass", "id_rsa_4096_testpass", "id_ecdsa_256_testpass", "id_ecdsa_384_testpass", "id_ecdsa_521_testpass", "id_ed25519_testpass", "id_ed25519_expensive_testpass"};

    @Test
    public void testSshWithoutConfig() throws Exception {
        Assert.assertThrows(TransportException.class, () -> {
            File file = this.cloneWith("ssh://testuser@localhost:" + this.testPort + "/doesntmatter", this.defaultCloneDir, null, new String[0]);
        });
    }

    @Test
    public void testSingleCommand() throws Exception {
        this.installConfig("IdentityFile " + this.privateKey1.getAbsolutePath());
        String command = "echo 1 without timeout";
        long start = System.nanoTime();
        String reply = SshSupport.runSshCommand((URIish)new URIish("ssh://testuser@localhost:" + this.testPort), null, (FS)FS.DETECTED, (String)command, (int)0);
        long elapsed = System.nanoTime() - start;
        Assert.assertEquals((Object)command, (Object)reply);
        command = "echo 1 expecting no timeout";
        int timeout = 10 * ((int)TimeUnit.NANOSECONDS.toSeconds(elapsed) + 1);
        reply = SshSupport.runSshCommand((URIish)new URIish("ssh://testuser@localhost:" + this.testPort), null, (FS)FS.DETECTED, (String)command, (int)timeout);
        Assert.assertEquals((Object)command, (Object)reply);
    }

    @Test
    public void testSingleCommandWithTimeoutExpired() throws Exception {
        this.installConfig("IdentityFile " + this.privateKey1.getAbsolutePath());
        String command = "echo 2 EXPECTING TIMEOUT";
        CommandFailedException e = (CommandFailedException)Assert.assertThrows(CommandFailedException.class, () -> {
            String string2 = SshSupport.runSshCommand((URIish)new URIish("ssh://testuser@localhost:" + this.testPort), null, (FS)FS.DETECTED, (String)command, (int)1);
        });
        Assert.assertTrue((boolean)e.getMessage().contains(command));
        Assert.assertTrue((boolean)e.getMessage().contains("time"));
    }

    @Test
    public void testSshWithGlobalIdentity() throws Exception {
        this.cloneWith("ssh://testuser@localhost:" + this.testPort + "/doesntmatter", this.defaultCloneDir, null, "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSshWithDefaultIdentity() throws Exception {
        File idRsa = new File(this.privateKey1.getParentFile(), "id_rsa");
        Files.copy(this.privateKey1.toPath(), idRsa.toPath(), new CopyOption[0]);
        this.cloneWith("ssh://testuser@localhost:" + this.testPort + "/doesntmatter", this.defaultCloneDir, null, new String[0]);
    }

    @Test
    public void testSshWithConfigEncryptedUnusedKey() throws Exception {
        File encryptedKey = new File(this.sshDir, "id_dsa");
        this.copyTestResource("id_dsa_testpass", encryptedKey);
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testpass");
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
        Assert.assertEquals((String)"CredentialsProvider should not have been called", (long)0L, (long)provider.getLog().size());
    }

    @Test
    public void testSshWithConfigEncryptedUnusedKeyInConfigLast() throws Exception {
        File encryptedKey = new File(this.sshDir, "id_dsa_test_key");
        this.copyTestResource("id_dsa_testpass", encryptedKey);
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testpass");
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "IdentityFile " + encryptedKey.getAbsolutePath());
        Assert.assertEquals((String)"CredentialsProvider should not have been called", (long)0L, (long)provider.getLog().size());
    }

    private boolean isJsch() {
        return this.getSessionFactory().getType().equals("jsch");
    }

    @Test
    public void testSshWithConfigEncryptedUnusedKeyInConfigFirst() throws Exception {
        if (this.isJsch()) {
            return;
        }
        File encryptedKey = new File(this.sshDir, "id_dsa_test_key");
        this.copyTestResource("id_dsa_testpass", encryptedKey);
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testpass");
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + encryptedKey.getAbsolutePath(), "IdentityFile " + this.privateKey1.getAbsolutePath());
        Assert.assertEquals((String)"CredentialsProvider should have been called once", (long)1L, (long)provider.getLog().size());
    }

    @Test
    public void testSshEncryptedUsedKeyCached() throws Exception {
        File encryptedKey = new File(this.sshDir, "id_dsa_test_key");
        this.copyTestResource("id_dsa_testpass", encryptedKey);
        File encryptedPublicKey = new File(this.sshDir, "id_dsa_test_key.pub");
        this.copyTestResource("id_dsa_testpass.pub", encryptedPublicKey);
        this.server.setTestUserPublicKey(encryptedPublicKey.toPath());
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testpass");
        this.pushTo(provider, this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + encryptedKey.getAbsolutePath()));
        Assert.assertEquals((String)"CredentialsProvider should have been called once", (long)1L, (long)provider.getLog().size());
    }

    @Test(expected=TransportException.class)
    public void testSshEncryptedUsedKeyWrongPassword() throws Exception {
        File encryptedKey = new File(this.sshDir, "id_dsa_test_key");
        this.copyTestResource("id_dsa_testpass", encryptedKey);
        File encryptedPublicKey = new File(this.sshDir, "id_dsa_test_key.pub");
        this.copyTestResource("id_dsa_testpass.pub", encryptedPublicKey);
        this.server.setTestUserPublicKey(encryptedPublicKey.toPath());
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass");
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "NumberOfPasswordPrompts 1", "IdentityFile " + encryptedKey.getAbsolutePath());
    }

    @Test
    public void testSshEncryptedUsedKeySeveralPassword() throws Exception {
        File encryptedKey = new File(this.sshDir, "id_dsa_test_key");
        this.copyTestResource("id_dsa_testpass", encryptedKey);
        File encryptedPublicKey = new File(this.sshDir, "id_dsa_test_key.pub");
        this.copyTestResource("id_dsa_testpass.pub", encryptedPublicKey);
        this.server.setTestUserPublicKey(encryptedPublicKey.toPath());
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass", "wrongpass2", "testpass");
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + encryptedKey.getAbsolutePath());
        Assert.assertEquals((String)"CredentialsProvider should have been called 3 times", (long)3L, (long)provider.getLog().size());
    }

    @Test(expected=TransportException.class)
    public void testSshWithoutKnownHosts() throws Exception {
        Assert.assertTrue((String)"Could not delete known_hosts", (boolean)this.knownHosts.delete());
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSshWithoutKnownHostsWithProviderAsk() throws Exception {
        File copiedHosts = new File(this.knownHosts.getParentFile(), "copiedKnownHosts");
        Assert.assertTrue((String)"Failed to rename known_hosts", (boolean)this.knownHosts.renameTo(copiedHosts));
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider(new String[0]);
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
        List<SshTestHarness.LogEntry> messages = provider.getLog();
        Assert.assertFalse((String)"Expected user interaction", (boolean)messages.isEmpty());
        if (this.isJsch()) {
            Assert.assertEquals((String)"Expected to be asked about the key", (long)1L, (long)messages.size());
            return;
        }
        Assert.assertEquals((String)"Expected to be asked about the key, and the file creation", (long)2L, (long)messages.size());
        Assert.assertTrue((String)"~/.ssh/known_hosts should exist now", (boolean)this.knownHosts.exists());
        File clonedAgain = new File(this.getTemporaryDirectory(), "cloned2");
        this.cloneWith("ssh://localhost/doesntmatter", clonedAgain, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSshWithoutKnownHostsWithProviderAcceptNew() throws Exception {
        File copiedHosts = new File(this.knownHosts.getParentFile(), "copiedKnownHosts");
        Assert.assertTrue((String)"Failed to rename known_hosts", (boolean)this.knownHosts.renameTo(copiedHosts));
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider(new String[0]);
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "StrictHostKeyChecking accept-new", "IdentityFile " + this.privateKey1.getAbsolutePath());
        if (this.isJsch()) {
            Assert.assertTrue((String)"CredentialsProvider not called", (boolean)provider.getLog().isEmpty());
            return;
        }
        Assert.assertEquals((String)"Expected to be asked about the file creation", (long)1L, (long)provider.getLog().size());
        Assert.assertTrue((String)"~/.ssh/known_hosts should exist now", (boolean)this.knownHosts.exists());
        File clonedAgain = new File(this.getTemporaryDirectory(), "cloned2");
        this.cloneWith("ssh://localhost/doesntmatter", clonedAgain, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test(expected=TransportException.class)
    public void testSshWithoutKnownHostsDeny() throws Exception {
        File copiedHosts = new File(this.knownHosts.getParentFile(), "copiedKnownHosts");
        Assert.assertTrue((String)"Failed to rename known_hosts", (boolean)this.knownHosts.renameTo(copiedHosts));
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "StrictHostKeyChecking yes", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test(expected=TransportException.class)
    public void testSshModifiedHostKeyDeny() throws Exception {
        File copiedHosts = new File(this.knownHosts.getParentFile(), "copiedKnownHosts");
        Assert.assertTrue((String)"Failed to rename known_hosts", (boolean)this.knownHosts.renameTo(copiedHosts));
        SshTestBase.createKnownHostsFile(this.knownHosts, "localhost", this.testPort, this.publicKey1);
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "StrictHostKeyChecking yes", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test(expected=TransportException.class)
    public void testSshModifiedHostKeyWithProviderDeny() throws Exception {
        File copiedHosts = new File(this.knownHosts.getParentFile(), "copiedKnownHosts");
        Assert.assertTrue((String)"Failed to rename known_hosts", (boolean)this.knownHosts.renameTo(copiedHosts));
        SshTestBase.createKnownHostsFile(this.knownHosts, "localhost", this.testPort, this.publicKey1);
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider(new String[0]);
        try {
            this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "StrictHostKeyChecking yes", "IdentityFile " + this.privateKey1.getAbsolutePath());
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Expected to be told about the modified key", (long)1L, (long)provider.getLog().size());
            Assert.assertTrue((String)"Only messages expected", (boolean)provider.getLog().stream().flatMap(l -> l.getItems().stream()).allMatch(c -> c instanceof CredentialItem.InformationalMessage));
            throw e;
        }
    }

    private void checkKnownHostsModifiedHostKey(File backup, File newFile, String wrongKey) throws IOException {
        List<String> oldLines = Files.readAllLines(backup.toPath(), StandardCharsets.UTF_8);
        String oldKeyPart = null;
        for (String oldLine : oldLines) {
            String[] parts;
            if (!oldLine.contains("[localhost]:") || (parts = oldLine.split("\\s+")).length <= 2) continue;
            oldKeyPart = String.valueOf(parts[parts.length - 2]) + ' ' + parts[parts.length - 1];
            break;
        }
        Assert.assertNotNull((String)"Old key not found", oldKeyPart);
        List<String> newLines = Files.readAllLines(newFile.toPath(), StandardCharsets.UTF_8);
        Assert.assertFalse((String)("Old host key still found in known_hosts file" + newFile), (boolean)this.hasHostKey("localhost", this.testPort, wrongKey, newLines));
        Assert.assertTrue((String)("New host key not found in known_hosts file" + newFile), (boolean)this.hasHostKey("localhost", this.testPort, oldKeyPart, newLines));
    }

    @Test
    public void testSshModifiedHostKeyAllow() throws Exception {
        Assert.assertTrue((String)"Failed to delete known_hosts", (boolean)this.knownHosts.delete());
        SshTestBase.createKnownHostsFile(this.knownHosts, "localhost", this.testPort, this.publicKey1);
        File backup = new File(this.getTemporaryDirectory(), "backupKnownHosts");
        Files.copy(this.knownHosts.toPath(), backup.toPath(), new CopyOption[0]);
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "StrictHostKeyChecking no", "IdentityFile " + this.privateKey1.getAbsolutePath());
        Object[] oldLines = Files.readAllLines(backup.toPath(), StandardCharsets.UTF_8).toArray(new String[0]);
        Object[] newLines = Files.readAllLines(this.knownHosts.toPath(), StandardCharsets.UTF_8).toArray(new String[0]);
        Assert.assertArrayEquals((String)"Known hosts file should not be modified", (Object[])oldLines, (Object[])newLines);
    }

    @Test
    public void testSshModifiedHostKeyAsk() throws Exception {
        File copiedHosts = new File(this.knownHosts.getParentFile(), "copiedKnownHosts");
        Assert.assertTrue((String)"Failed to rename known_hosts", (boolean)this.knownHosts.renameTo(copiedHosts));
        String wrongKeyPart = SshTestBase.createKnownHostsFile(this.knownHosts, "localhost", this.testPort, this.publicKey1);
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider(new String[0]);
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
        this.checkKnownHostsModifiedHostKey(copiedHosts, this.knownHosts, wrongKeyPart);
        Assert.assertEquals((String)"Expected to be asked about the modified key", (long)1L, (long)provider.getLog().size());
    }

    @Test
    public void testSshCloneWithConfigAndPush() throws Exception {
        this.pushTo(this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath()));
    }

    @Test
    public void testSftpWithConfig() throws Exception {
        this.cloneWith("sftp://localhost/.git", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSftpCloneWithConfigAndPush() throws Exception {
        this.pushTo(this.cloneWith("sftp://localhost/.git", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath()));
    }

    @Test(expected=TransportException.class)
    public void testSshWithConfigWrongKey() throws Exception {
        this.cloneWith("ssh://localhost/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey2.getAbsolutePath());
    }

    @Test
    public void testSshWithWrongUserNameInConfig() throws Exception {
        this.cloneWith("ssh://testuser@localhost:" + this.testPort + "/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "User sombody_else", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSshWithWrongPortInConfig() throws Exception {
        this.cloneWith("ssh://testuser@localhost:" + this.testPort + "/doesntmatter", this.defaultCloneDir, null, "Host localhost", "HostName localhost", "Port 22", "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testSshWithAliasInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "", "Host localhost", "HostName localhost", "Port 22", "User someone_else", "IdentityFile " + this.privateKey2.getAbsolutePath());
    }

    @Test
    public void testSshWithUnknownCiphersInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "Ciphers chacha20-poly1305@openssh.com,aes256-gcm@openssh.com,aes128-gcm@openssh.com,aes256-ctr,aes192-ctr,aes128-ctr");
    }

    @Test
    public void testSshWithUnknownHostKeyAlgorithmsInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "HostKeyAlgorithms foobar,ssh-rsa,ssh-dss");
    }

    @Test
    public void testSshWithUnknownKexAlgorithmsInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "KexAlgorithms foobar,diffie-hellman-group14-sha1,ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521");
    }

    @Test
    public void testSshWithMinimalHostKeyAlgorithmsInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "HostKeyAlgorithms ssh-rsa,ssh-dss");
    }

    @Test
    public void testSshWithUnknownAuthInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "PreferredAuthentications gssapi-with-mic,hostbased,publickey,keyboard-interactive,password");
    }

    @Test(expected=TransportException.class)
    public void testSshWithNoMatchingAuthInConfig() throws Exception {
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath(), "PreferredAuthentications password");
    }

    @Test
    public void testRsaHostKeySecond() throws Exception {
        File newHostKey = new File(this.getTemporaryDirectory(), "newhostkey");
        this.copyTestResource("id_ecdsa_256", newHostKey);
        this.server.addHostKey(newHostKey.toPath(), true);
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testEcDsaHostKey() throws Exception {
        File newHostKey = new File(this.getTemporaryDirectory(), "newhostkey");
        this.copyTestResource("id_ecdsa_256", newHostKey);
        this.server.addHostKey(newHostKey.toPath(), false);
        File newHostKeyPub = new File(this.getTemporaryDirectory(), "newhostkey.pub");
        this.copyTestResource("id_ecdsa_256.pub", newHostKeyPub);
        SshTestBase.createKnownHostsFile(this.knownHosts, "localhost", this.testPort, newHostKeyPub);
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, null, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + this.privateKey1.getAbsolutePath());
    }

    @Test
    public void testPasswordAuth() throws Exception {
        this.server.enablePasswordAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testuser".toUpperCase(Locale.ROOT));
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications password");
    }

    @Test
    public void testPasswordAuthSeveralTimes() throws Exception {
        this.server.enablePasswordAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass", "wrongpass", "testuser".toUpperCase(Locale.ROOT));
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications password");
    }

    @Test(expected=TransportException.class)
    public void testPasswordAuthWrongPassword() throws Exception {
        this.server.enablePasswordAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass");
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications password");
    }

    @Test(expected=TransportException.class)
    public void testPasswordAuthNoPassword() throws Exception {
        this.server.enablePasswordAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider(new String[0]);
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications password");
    }

    @Test(expected=TransportException.class)
    public void testPasswordAuthCorrectPasswordTooLate() throws Exception {
        this.server.enablePasswordAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass", "wrongpass", "wrongpass", "testuser".toUpperCase(Locale.ROOT));
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications password");
    }

    @Test
    public void testKeyboardInteractiveAuth() throws Exception {
        this.server.enableKeyboardInteractiveAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testuser".toUpperCase(Locale.ROOT));
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications keyboard-interactive");
    }

    @Test
    public void testKeyboardInteractiveAuthSeveralTimes() throws Exception {
        this.server.enableKeyboardInteractiveAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass", "wrongpass", "testuser".toUpperCase(Locale.ROOT));
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications keyboard-interactive");
    }

    @Test(expected=TransportException.class)
    public void testKeyboardInteractiveAuthWrongPassword() throws Exception {
        this.server.enableKeyboardInteractiveAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass");
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications keyboard-interactive");
    }

    @Test(expected=TransportException.class)
    public void testKeyboardInteractiveAuthNoPassword() throws Exception {
        this.server.enableKeyboardInteractiveAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider(new String[0]);
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications keyboard-interactive");
    }

    @Test(expected=TransportException.class)
    public void testKeyboardInteractiveAuthCorrectPasswordTooLate() throws Exception {
        this.server.enableKeyboardInteractiveAuthentication();
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("wrongpass", "wrongpass", "wrongpass", "testuser".toUpperCase(Locale.ROOT));
        this.cloneWith("ssh://git/doesntmatter", this.defaultCloneDir, provider, "Host git", "HostName localhost", "Port " + this.testPort, "User testuser", "PreferredAuthentications keyboard-interactive");
    }

    @Theory
    public void testSshKeys(String keyName) throws Exception {
        Assume.assumeTrue((!this.isJsch() || !keyName.contains("ed25519") && !keyName.startsWith("id_ecdsa_384") && !keyName.startsWith("id_ecdsa_521") ? 1 : 0) != 0);
        File cloned = new File(this.getTemporaryDirectory(), "cloned");
        String keyFileName = String.valueOf(keyName) + "_key";
        File privateKey = new File(this.sshDir, keyFileName);
        this.copyTestResource(keyName, privateKey);
        File publicKey = new File(this.sshDir, String.valueOf(keyFileName) + ".pub");
        this.copyTestResource(String.valueOf(keyName) + ".pub", publicKey);
        this.server.setTestUserPublicKey(publicKey.toPath());
        SshTestHarness.TestCredentialsProvider provider = new SshTestHarness.TestCredentialsProvider("testpass");
        this.pushTo(provider, this.cloneWith("ssh://localhost/doesntmatter", cloned, provider, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + privateKey.getAbsolutePath()));
        int expectedCalls = keyName.endsWith("testpass") ? 1 : 0;
        Assert.assertEquals((String)"Unexpected calls to CredentialsProvider", (long)expectedCalls, (long)provider.getLog().size());
        cloned = new File(this.getTemporaryDirectory(), "cloned2");
        this.pushTo(null, this.cloneWith("ssh://localhost/doesntmatter", cloned, null, "Host localhost", "HostName localhost", "Port " + this.testPort, "User testuser", "IdentityFile " + privateKey.getAbsolutePath()));
    }
}

