/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.ssh;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.junit.RepositoryTestCase;
import org.eclipse.jgit.junit.ssh.SshTestGitServer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.junit.After;
import org.junit.Assert;

public abstract class SshTestHarness
extends RepositoryTestCase {
    protected static final String TEST_USER = "testuser";
    protected File sshDir;
    protected File privateKey1;
    protected File privateKey2;
    protected File publicKey1;
    protected File publicKey2;
    protected SshTestGitServer server;
    private SshSessionFactory factory;
    protected int testPort;
    protected File knownHosts;

    public void setUp() throws Exception {
        super.setUp();
        this.writeTrashFile("file.txt", "something");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git((Repository)this.db);){
            git.add().addFilepattern("file.txt").call();
            git.commit().setMessage("Initial commit").call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.sshDir = new File(FS.DETECTED.userHome(), ".ssh");
        Assert.assertTrue((boolean)this.sshDir.mkdir());
        File serverDir = new File(this.getTemporaryDirectory(), "srv");
        Assert.assertTrue((boolean)serverDir.mkdir());
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        this.privateKey1 = new File(this.sshDir, "first_key");
        this.privateKey2 = new File(this.sshDir, "second_key");
        this.publicKey1 = SshTestHarness.createKeyPair(generator.generateKeyPair(), this.privateKey1);
        this.publicKey2 = SshTestHarness.createKeyPair(generator.generateKeyPair(), this.privateKey2);
        KeyPair hostKey = generator.generateKeyPair();
        this.server = new SshTestGitServer(TEST_USER, this.publicKey1.toPath(), (Repository)this.db, hostKey);
        this.testPort = this.server.start();
        Assert.assertTrue((this.testPort > 0 ? 1 : 0) != 0);
        this.knownHosts = new File(this.sshDir, "known_hosts");
        StringBuilder knownHostsLine = new StringBuilder();
        knownHostsLine.append("[localhost]:").append(this.testPort).append(' ');
        PublicKeyEntry.appendPublicKeyEntry((Appendable)knownHostsLine, (PublicKey)hostKey.getPublic());
        Files.write(this.knownHosts.toPath(), Collections.singleton(knownHostsLine.toString()), new OpenOption[0]);
        this.factory = this.createSessionFactory();
        SshSessionFactory.setInstance((SshSessionFactory)this.factory);
    }

    private static File createKeyPair(KeyPair newKey, File privateKeyFile) throws Exception {
        PrivateKey privateKey = newKey.getPrivate();
        String format = privateKey.getFormat();
        if (!"PKCS#8".equalsIgnoreCase(format)) {
            throw new IOException("Cannot write " + privateKey.getAlgorithm() + " key in " + format + " format");
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(privateKeyFile.toPath(), StandardCharsets.US_ASCII, new OpenOption[0]);){
            writer.write("-----BEGIN PRIVATE KEY-----");
            writer.newLine();
            SshTestHarness.write(writer, privateKey.getEncoded(), 64);
            writer.write("-----END PRIVATE KEY-----");
            writer.newLine();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File publicKeyFile = new File(privateKeyFile.getParentFile(), String.valueOf(privateKeyFile.getName()) + ".pub");
        StringBuilder builder = new StringBuilder();
        PublicKeyEntry.appendPublicKeyEntry((Appendable)builder, (PublicKey)newKey.getPublic());
        builder.append(' ').append(TEST_USER);
        Throwable throwable3 = null;
        Object var7_10 = null;
        try (FileOutputStream out = new FileOutputStream(publicKeyFile);){
            ((OutputStream)out).write(builder.toString().getBytes(StandardCharsets.US_ASCII));
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        return publicKeyFile;
    }

    private static void write(BufferedWriter out, byte[] bytes, int lineLength) throws IOException {
        String data = Base64.getEncoder().encodeToString(bytes);
        int last = data.length();
        int i = 0;
        while (i < last) {
            if (i + lineLength <= last) {
                out.write(data.substring(i, i + lineLength));
            } else {
                out.write(data.substring(i));
            }
            out.newLine();
            i += lineLength;
        }
        Arrays.fill(bytes, (byte)0);
    }

    protected static String createKnownHostsFile(File file, String host, int port, File publicKey) throws IOException {
        List<String> lines = Files.readAllLines(publicKey.toPath(), StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Public key has too many lines", (long)1L, (long)lines.size());
        String pubKey = lines.get(0);
        String[] parts = pubKey.split("\\s+");
        Assert.assertTrue((String)"Unexpected key content", (parts.length == 2 || parts.length == 3 ? 1 : 0) != 0);
        String keyPart = String.valueOf(parts[0]) + ' ' + parts[1];
        String line = String.valueOf('[') + host + "]:" + port + ' ' + keyPart;
        Files.write(file.toPath(), Collections.singletonList(line), new OpenOption[0]);
        return keyPart;
    }

    protected boolean hasHostKey(String host, int port, String keyPart, List<String> lines) {
        String h = String.valueOf('[') + host + "]:" + port;
        return lines.stream().anyMatch(l -> l.contains(h) && l.contains(keyPart));
    }

    @After
    public void shutdownServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        SshSessionFactory.setInstance(null);
        this.factory = null;
    }

    protected abstract SshSessionFactory createSessionFactory();

    protected SshSessionFactory getSessionFactory() {
        return this.factory;
    }

    protected abstract void installConfig(String ... var1);

    protected void copyTestResource(String resourceName, File to) throws IOException {
        this.copyTestResource(SshTestHarness.class, resourceName, to);
    }

    protected void copyTestResource(Class<?> loader, String resourceName, File to) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = loader.getResourceAsStream(resourceName);){
            Files.copy(in, to.toPath(), new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected File cloneWith(String uri, File to, CredentialsProvider provider, String ... config) throws Exception {
        this.installConfig(config);
        CloneCommand clone = Git.cloneRepository().setCloneAllBranches(true).setDirectory(to).setURI(uri);
        if (provider != null) {
            clone.setCredentialsProvider(provider);
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (Git git = clone.call();){
            Repository repo = git.getRepository();
            Assert.assertNotNull((Object)repo.resolve("master"));
            Assert.assertNotEquals((Object)this.db.getWorkTree(), (Object)git.getRepository().getWorkTree());
            Assert.assertTrue((boolean)new File(git.getRepository().getWorkTree(), "file.txt").exists());
            return repo.getWorkTree();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void pushTo(File localClone) throws Exception {
        this.pushTo(null, localClone);
    }

    protected void pushTo(CredentialsProvider provider, File localClone) throws Exception {
        RevCommit commit;
        File newFile = null;
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (Git git = Git.open((File)localClone);){
            Repository local = git.getRepository();
            newFile = File.createTempFile("new", "sshtest", local.getWorkTree());
            this.write(newFile, "something new");
            File existingFile = new File(local.getWorkTree(), "file.txt");
            this.write(existingFile, "something else");
            git.add().addFilepattern("file.txt").addFilepattern(newFile.getName()).call();
            commit = git.commit().setMessage("Local commit").call();
            PushCommand push = git.push().setPushAll();
            if (provider != null) {
                push.setCredentialsProvider(provider);
            }
            Iterable results = push.call();
            for (PushResult result : results) {
                for (RemoteRefUpdate u : result.getRemoteUpdates()) {
                    Assert.assertEquals((String)("Could not update " + u.getRemoteName() + ' ' + u.getMessage()), (Object)RemoteRefUpdate.Status.OK, (Object)u.getStatus());
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Assert.assertEquals((String)"Unexpected remote commit", (Object)commit, (Object)this.db.resolve("master"));
        Assert.assertEquals((String)"Unexpected remote commit", (Object)commit, (Object)this.db.resolve("HEAD"));
        File remoteFile = new File(this.db.getWorkTree(), newFile.getName());
        Assert.assertFalse((String)"File should not exist on remote", (boolean)remoteFile.exists());
        throwable2 = null;
        Object var7_9 = null;
        try (Git git = new Git((Repository)this.db);){
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        Assert.assertTrue((String)"File does not exist on remote", (boolean)remoteFile.exists());
        SshTestHarness.checkFile((File)remoteFile, (String)"something new");
    }

    protected static class LogEntry {
        private URIish uri;
        private List<CredentialItem> items;

        public LogEntry(URIish uri, List<CredentialItem> items) {
            this.uri = uri;
            this.items = items;
        }

        public URIish getURIish() {
            return this.uri;
        }

        public List<CredentialItem> getItems() {
            return this.items;
        }
    }

    protected static class TestCredentialsProvider
    extends CredentialsProvider {
        private final List<String> stringStore;
        private final Iterator<String> strings;
        private List<LogEntry> log = new ArrayList<LogEntry>();

        public TestCredentialsProvider(String ... strings) {
            this.stringStore = strings == null || strings.length == 0 ? Collections.emptyList() : Arrays.asList(strings);
            this.strings = this.stringStore.iterator();
        }

        public boolean isInteractive() {
            return true;
        }

        public boolean supports(CredentialItem ... items) {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
            CredentialItem item;
            System.out.println("URI: " + uri);
            CredentialItem[] credentialItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                item = credentialItemArray[n2];
                System.out.println(String.valueOf(item.getClass().getSimpleName()) + ' ' + item.getPromptText());
                ++n2;
            }
            this.logItems(uri, items);
            credentialItemArray = items;
            n = items.length;
            n2 = 0;
            while (n2 < n) {
                item = credentialItemArray[n2];
                if (!(item instanceof CredentialItem.InformationalMessage)) {
                    if (item instanceof CredentialItem.YesNoType) {
                        ((CredentialItem.YesNoType)item).setValue(true);
                    } else if (item instanceof CredentialItem.CharArrayType) {
                        if (!this.strings.hasNext()) return false;
                        ((CredentialItem.CharArrayType)item).setValue(this.strings.next().toCharArray());
                    } else {
                        if (!(item instanceof CredentialItem.StringType)) return false;
                        if (!this.strings.hasNext()) return false;
                        ((CredentialItem.StringType)item).setValue(this.strings.next());
                    }
                }
                ++n2;
            }
            return true;
        }

        private void logItems(URIish uri, CredentialItem ... items) {
            this.log.add(new LogEntry(uri, Arrays.asList(items)));
        }

        public List<LogEntry> getLog() {
            return this.log;
        }
    }
}

