/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.JGitTestUtil;
import org.eclipse.jgit.junit.LocalDiskRepositoryTestCase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;

public abstract class RepositoryTestCase
extends LocalDiskRepositoryTestCase {
    protected FileRepository db;
    protected File trash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFile(File src, File dst) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dst);){
            int r;
            byte[] buf = new byte[4096];
            while ((r = fis.read(buf)) > 0) {
                fos.write(buf, 0, r);
            }
        }
    }

    protected File writeTrashFile(String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, name, data);
    }

    protected Path writeLink(String link, String target) throws Exception {
        return JGitTestUtil.writeLink((Repository)this.db, link, target);
    }

    protected File writeTrashFile(String subdir, String name, String data) throws IOException {
        return JGitTestUtil.writeTrashFile((Repository)this.db, subdir, name, data);
    }

    protected String read(String name) throws IOException {
        return JGitTestUtil.read((Repository)this.db, name);
    }

    protected boolean check(String name) {
        return JGitTestUtil.check((Repository)this.db, name);
    }

    protected void deleteTrashFile(String name) throws IOException {
        JGitTestUtil.deleteTrashFile((Repository)this.db, name);
    }

    protected static void checkFile(File f, String checkData) throws IOException {
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
            if (checkData.length() > 0) {
                char[] data = new char[checkData.length()];
                Assert.assertEquals((long)data.length, (long)r.read(data));
                Assert.assertEquals((Object)checkData, (Object)new String(data));
            }
            Assert.assertEquals((long)-1L, (long)((Reader)r).read());
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.db = this.createWorkRepository();
        this.trash = this.db.getWorkTree();
    }

    public String indexState(int includedOptions) throws IllegalStateException, IOException {
        return RepositoryTestCase.indexState((Repository)this.db, includedOptions);
    }

    protected void resetIndex(FileTreeIterator treeItr) throws FileNotFoundException, IOException {
        try (ObjectInserter inserter = this.db.newObjectInserter();){
            DirCacheBuilder builder = this.db.lockDirCache().builder();
            while (!treeItr.eof()) {
                long len = treeItr.getEntryLength();
                DirCacheEntry dce = new DirCacheEntry(treeItr.getEntryPathString());
                dce.setFileMode(treeItr.getEntryFileMode());
                dce.setLastModified(treeItr.getEntryLastModified());
                dce.setLength((int)len);
                FileInputStream in = new FileInputStream(treeItr.getEntryFile());
                dce.setObjectId((AnyObjectId)inserter.insert(3, len, (InputStream)in));
                in.close();
                builder.add(dce);
                treeItr.next(1);
            }
            builder.commit();
            inserter.flush();
        }
    }

    public static String lookup(Object l, String nameTemplate, Map<Object, String> lookupTable) {
        String name = lookupTable.get(l);
        if (name == null) {
            name = nameTemplate.replaceAll("%n", Integer.toString(lookupTable.size()));
            lookupTable.put(l, name);
        }
        return name;
    }

    public static String slashify(String str) {
        str = str.replace('\\', '/');
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fsTick(File lastFile) throws InterruptedException, IOException {
        long sleepTime = 64L;
        FS fs = FS.DETECTED;
        if (lastFile != null && !fs.exists(lastFile)) {
            throw new FileNotFoundException(lastFile.getPath());
        }
        File tmp = File.createTempFile("FileTreeIteratorWithTimeControl", null);
        try {
            long startTime = lastFile == null ? fs.lastModified(tmp) : fs.lastModified(lastFile);
            long actTime = fs.lastModified(tmp);
            while (actTime <= startTime) {
                Thread.sleep(sleepTime);
                sleepTime *= 2L;
                FileOutputStream fos = new FileOutputStream(tmp);
                fos.close();
                actTime = fs.lastModified(tmp);
            }
            long l = actTime;
            return l;
        }
        finally {
            FileUtils.delete((File)tmp);
        }
    }

    protected void createBranch(ObjectId objectId, String branchName) throws IOException {
        RefUpdate updateRef = this.db.updateRef(branchName);
        updateRef.setNewObjectId((AnyObjectId)objectId);
        updateRef.update();
    }

    protected void checkoutBranch(String branchName) throws IllegalStateException, IOException {
        try (RevWalk walk = new RevWalk((Repository)this.db);){
            RevCommit head = walk.parseCommit((AnyObjectId)this.db.resolve("HEAD"));
            RevCommit branch = walk.parseCommit((AnyObjectId)this.db.resolve(branchName));
            DirCacheCheckout dco = new DirCacheCheckout((Repository)this.db, head.getTree().getId(), this.db.lockDirCache(), branch.getTree().getId());
            dco.setFailOnConflict(true);
            dco.checkout();
        }
        RefUpdate refUpdate = this.db.updateRef("HEAD");
        refUpdate.setRefLogMessage("checkout: moving to " + branchName, false);
        refUpdate.link(branchName);
    }

    protected File writeTrashFiles(boolean ensureDistinctTimestamps, String ... contents) throws IOException, InterruptedException {
        File f = null;
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            if (ensureDistinctTimestamps && f != null) {
                RepositoryTestCase.fsTick(f);
            }
            f = this.writeTrashFile(Integer.toString(i), contents[i]);
        }
        return f;
    }

    protected RevCommit commitFile(String filename, String contents, String branch) {
        RevCommit revCommit;
        Git git = new Git((Repository)this.db);
        Throwable throwable = null;
        try {
            boolean empty;
            Repository repo = git.getRepository();
            String originalBranch = repo.getFullBranch();
            boolean bl = empty = repo.resolve("HEAD") == null;
            if (!empty) {
                if (repo.findRef(branch) == null) {
                    git.branchCreate().setName(branch).call();
                }
                git.checkout().setName(branch).call();
            }
            this.writeTrashFile(filename, contents);
            git.add().addFilepattern(filename).call();
            RevCommit commit = git.commit().setMessage(branch + ": " + filename).call();
            if (originalBranch != null) {
                git.checkout().setName(originalBranch).call();
            } else if (empty) {
                git.branchCreate().setName(branch).setStartPoint(commit).call();
            }
            revCommit = commit;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    RepositoryTestCase.$closeResource(throwable, (AutoCloseable)git);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (GitAPIException e) {
                throw new RuntimeException(e);
            }
        }
        RepositoryTestCase.$closeResource(throwable, (AutoCloseable)git);
        return revCommit;
    }

    protected DirCacheEntry createEntry(String path, FileMode mode) {
        return this.createEntry(path, mode, 0, path);
    }

    protected DirCacheEntry createEntry(String path, FileMode mode, String content) {
        return this.createEntry(path, mode, 0, content);
    }

    protected DirCacheEntry createEntry(String path, FileMode mode, int stage, String content) {
        DirCacheEntry entry = new DirCacheEntry(path, stage);
        entry.setFileMode(mode);
        try (ObjectInserter.Formatter formatter = new ObjectInserter.Formatter();){
            entry.setObjectId((AnyObjectId)formatter.idFor(3, Constants.encode((String)content)));
        }
        return entry;
    }

    public static void assertEqualsFile(File expected, File actual) throws IOException {
        Assert.assertEquals((Object)expected.getCanonicalFile(), (Object)actual.getCanonicalFile());
    }
}

