/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.kohsuke.args4j.Option;

abstract class AbstractFetchCommand
extends TextBuiltin {
    @Option(name="--verbose", aliases={"-v"}, usage="usage_beMoreVerbose")
    private boolean verbose;

    AbstractFetchCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showFetchResult(FetchResult r) {
        ObjectReader reader = this.db.newObjectReader();
        try {
            boolean shownURI = false;
            for (TrackingRefUpdate u : r.getTrackingRefUpdates()) {
                if (!this.verbose && u.getResult() == RefUpdate.Result.NO_CHANGE) continue;
                char type = AbstractFetchCommand.shortTypeOf(u.getResult());
                String longType = this.longTypeOf(reader, u);
                String src = this.abbreviateRef(u.getRemoteName(), false);
                String dst = this.abbreviateRef(u.getLocalName(), true);
                if (!shownURI) {
                    this.out.println(MessageFormat.format(CLIText.get().fromURI, r.getURI()));
                    shownURI = true;
                }
                this.out.format(" %c %-17s %-10s -> %s", Character.valueOf(type), longType, src, dst);
                this.out.println();
            }
        }
        finally {
            reader.release();
        }
        AbstractFetchCommand.showRemoteMessages(r.getMessages());
    }

    static void showRemoteMessages(String pkt) {
        PrintWriter writer = new PrintWriter(System.err);
        while (0 < pkt.length()) {
            int s;
            int lf = pkt.indexOf(10);
            int cr = pkt.indexOf(13);
            if (0 <= lf && 0 <= cr) {
                s = Math.min(lf, cr);
            } else if (0 <= lf) {
                s = lf;
            } else if (0 <= cr) {
                s = cr;
            } else {
                writer.print(MessageFormat.format(CLIText.get().remoteMessage, pkt));
                writer.println();
                break;
            }
            if (pkt.charAt(s) == '\r') {
                writer.print(MessageFormat.format(CLIText.get().remoteMessage, pkt.substring(0, s)));
                writer.print('\r');
            } else {
                writer.print(MessageFormat.format(CLIText.get().remoteMessage, pkt.substring(0, s)));
                writer.println();
            }
            pkt = pkt.substring(s + 1);
        }
        writer.flush();
    }

    private String longTypeOf(ObjectReader reader, TrackingRefUpdate u) {
        RefUpdate.Result r = u.getResult();
        if (r == RefUpdate.Result.LOCK_FAILURE) {
            return "[lock fail]";
        }
        if (r == RefUpdate.Result.IO_FAILURE) {
            return "[i/o error]";
        }
        if (r == RefUpdate.Result.REJECTED) {
            return "[rejected]";
        }
        if (ObjectId.zeroId().equals((AnyObjectId)u.getNewObjectId())) {
            return "[deleted]";
        }
        if (r == RefUpdate.Result.NEW) {
            if (u.getRemoteName().startsWith("refs/heads/")) {
                return "[new branch]";
            }
            if (u.getLocalName().startsWith("refs/tags/")) {
                return "[new tag]";
            }
            return "[new]";
        }
        if (r == RefUpdate.Result.FORCED) {
            String aOld = this.safeAbbreviate(reader, u.getOldObjectId());
            String aNew = this.safeAbbreviate(reader, u.getNewObjectId());
            return aOld + "..." + aNew;
        }
        if (r == RefUpdate.Result.FAST_FORWARD) {
            String aOld = this.safeAbbreviate(reader, u.getOldObjectId());
            String aNew = this.safeAbbreviate(reader, u.getNewObjectId());
            return aOld + ".." + aNew;
        }
        if (r == RefUpdate.Result.NO_CHANGE) {
            return "[up to date]";
        }
        return "[" + r.name() + "]";
    }

    private String safeAbbreviate(ObjectReader reader, ObjectId id) {
        try {
            return reader.abbreviate((AnyObjectId)id).name();
        }
        catch (IOException cannotAbbreviate) {
            return id.name();
        }
    }

    private static char shortTypeOf(RefUpdate.Result r) {
        if (r == RefUpdate.Result.LOCK_FAILURE) {
            return '!';
        }
        if (r == RefUpdate.Result.IO_FAILURE) {
            return '!';
        }
        if (r == RefUpdate.Result.NEW) {
            return '*';
        }
        if (r == RefUpdate.Result.FORCED) {
            return '+';
        }
        if (r == RefUpdate.Result.FAST_FORWARD) {
            return ' ';
        }
        if (r == RefUpdate.Result.REJECTED) {
            return '!';
        }
        if (r == RefUpdate.Result.NO_CHANGE) {
            return '=';
        }
        return ' ';
    }
}

